package com.ruoyi.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-中靶要求-定向井对象 sj_zlyq_zbyq
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
public class SjZlyqZbyq extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 靶点 */
    @Excel(name = "靶点")
    private String bd;

    /** 靶半径 */
    @Excel(name = "靶半径")
    private Double bbj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setBd(String bd) 
    {
        this.bd = bd;
    }

    public String getBd() 
    {
        return bd;
    }

    public void setBbj(Double bbj) 
    {
        this.bbj = bbj;
    }

    public Double getBbj() 
    {
        return bbj;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("bd", getBd())
            .append("bbj", getBbj())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
