package com.ruoyi.project.zjsgfa.controller;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.project.zjsgfa.domain.SjDjjc;
import com.ruoyi.project.zjsgfa.domain.SjJsjgt;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjJsjg;
import com.ruoyi.project.zjsgfa.service.ISjJsjgService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 设计信息-井身结构Controller
 * 
 * @author ruoyi
 * @date 2025-06-24
 */
@RestController
@RequestMapping("/system/sjJsjg")
public class SjJsjgController extends BaseController
{
    @Autowired
    private ISjJsjgService sjJsjgService;

    /**
     * 查询设计信息-井身结构列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJsjg sjJsjg)
    {
//        startPage();
        List<SjJsjg> list = sjJsjgService.selectSjJsjgList(sjJsjg);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井身结构列表
     */
//    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:export')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJsjg sjJsjg)
    {
        List<SjJsjg> list = sjJsjgService.selectSjJsjgList(sjJsjg);
        ExcelUtil<SjJsjg> util = new ExcelUtil<SjJsjg>(SjJsjg.class);
        util.exportExcel(response, list, "设计信息-井身结构数据");
    }

    /**
     * 获取设计信息-井身结构详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJsjgService.selectSjJsjgById(id));
    }

    /**
     * 新增设计信息-井身结构
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:add')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJsjg sjJsjg)
    {
        return toAjax(sjJsjgService.insertSjJsjg(sjJsjg));
    }

    /**
     * 修改设计信息-井身结构
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:edit')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJsjg sjJsjg)
    {
        return toAjax(sjJsjgService.updateSjJsjg(sjJsjg));
    }

    /**
     * 删除设计信息-井身结构
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:remove')")
    @Log(title = "设计信息-井身结构", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJsjgService.deleteSjJsjgByIds(ids));
    }


    @PostMapping("/savaJsjgt")
    public AjaxResult savaJsjgt(@RequestBody  SjJsjgt sjJsjg)
    {
      return AjaxResult.success(sjJsjgService.savaJsjgt(sjJsjg));
    }





    /**
     * 查询井身结构图
     */
    @GetMapping("/jsjgt")
    public String  jsjgt(SjJsjg sjJsjg)
    {

        Map jsjgt = sjJsjgService.selectJsjgt(sjJsjg);
        JSONObject jsonObject = new JSONObject(jsjgt);
        String jsonString = jsonObject.toJSONString();
        return jsonString;
    }





    /**
     * 导入数据
     */
//    //@PreAuthorize("@ss.hasPermi('system:sjJsjg:importData')")
    @PostMapping("/importData")
    @ResponseBody
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        XSSFWorkbook workbook = null;
        try {
            //装载流
            workbook = new XSSFWorkbook(file.getInputStream());
            // 获取一个工作表，下标从0开始
            XSSFSheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            // 通过循环，逐行取出表中每行数据

            for(int i=0;i<=lastRowNum;i++){//跳过第一行
                if(i==0){
                    continue;
                }
                // 获取行
                XSSFRow row = sheet.getRow(i);
                System.out.println(row);
                SjJsjg info=new SjJsjg();

                String jh=new DataFormatter().formatCellValue(row.getCell(0));
                if(StringUtils.isEmpty(jh)){
                    return AjaxResult.error("第"+(i+1)+"行井号不能为空");
                }
                info.setJh(jh);

                String kc=new DataFormatter().formatCellValue(row.getCell(1));
                if(StringUtils.isEmpty(kc)){
                    return AjaxResult.error("第"+(i+1)+"行开次不能为空");
                }
                info.setKc(kc);
                String ztzj=new DataFormatter().formatCellValue(row.getCell(2));
                if(StringUtils.isEmpty(ztzj)){
                    return AjaxResult.error("第"+(i+1)+"行钻头直径不能为空");
                }
                info.setZtzj(Double.parseDouble(ztzj));

                String js=new DataFormatter().formatCellValue(row.getCell(3));
                if(StringUtils.isEmpty(js)){
                    return AjaxResult.error("第"+(i+1)+"行井深不能为空");
                }
                info.setJs(Double.parseDouble(js));

                String tgwj=new DataFormatter().formatCellValue(row.getCell(4));
                if(StringUtils.isEmpty(tgwj)){
                    return AjaxResult.error("第"+(i+1)+"行套管外径不能为空");
                }
                info.setTtwj(Double.parseDouble(tgwj));


                String ttds=new DataFormatter().formatCellValue(row.getCell(5));
                if(StringUtils.isEmpty(ttds)){
                    return AjaxResult.error("第"+(i+1)+"行套管顶深不能为空");
                }
                info.setTtds(Double.parseDouble(ttds));

                String ttxs=new DataFormatter().formatCellValue(row.getCell(6));
                if(StringUtils.isEmpty(ttxs)){
                    return AjaxResult.error("第"+(i+1)+"行套管下深不能为空");
                }
                info.setTtxs(Double.parseDouble(ttxs));
                String snfg=new DataFormatter().formatCellValue(row.getCell(7));
                if(StringUtils.isEmpty(snfg)){
                    return AjaxResult.error("第"+(i+1)+"行水泥返高不能为空");
                }
                info.setSnfg(Double.parseDouble(snfg));

                String  bz=new DataFormatter().formatCellValue(row.getCell(8));

                info.setBz(bz);
                sjJsjgService.insertSjJsjg(info);
            }

        } catch (IOException e) {
            e.getMessage();
            e.printStackTrace();
            throw new Exception("导入Excel失败，请联系网站管理员！");

        } finally {
            workbook.close();
        }

        return AjaxResult.success("导入成功");
    }






}
