package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjFdsgcsTsgj;
import com.ruoyi.project.zjsgfa.service.ISjFdsgcsTsgjService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计-分段施工措施_特殊工具Controller
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
@RestController
@RequestMapping("/system/sjFdsgcsTsgj")
public class SjFdsgcsTsgjController extends BaseController
{
    @Autowired
    private ISjFdsgcsTsgjService sjFdsgcsTsgjService;

    /**
     * 查询设计-分段施工措施_特殊工具列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        startPage();
        List<SjFdsgcsTsgj> list = sjFdsgcsTsgjService.selectSjFdsgcsTsgjList(sjFdsgcsTsgj);
        return getDataTable(list);
    }

    /**
     * 导出设计-分段施工措施_特殊工具列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:export')")
    @Log(title = "设计-分段施工措施_特殊工具", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        List<SjFdsgcsTsgj> list = sjFdsgcsTsgjService.selectSjFdsgcsTsgjList(sjFdsgcsTsgj);
        ExcelUtil<SjFdsgcsTsgj> util = new ExcelUtil<SjFdsgcsTsgj>(SjFdsgcsTsgj.class);
        util.exportExcel(response, list, "设计-分段施工措施_特殊工具数据");
    }

    /**
     * 获取设计-分段施工措施_特殊工具详细信息
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsTsgjService.selectSjFdsgcsTsgjById(id));
    }

    /**
     * 新增设计-分段施工措施_特殊工具
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:add')")
    @Log(title = "设计-分段施工措施_特殊工具", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        return toAjax(sjFdsgcsTsgjService.insertSjFdsgcsTsgj(sjFdsgcsTsgj));
    }

    /**
     * 修改设计-分段施工措施_特殊工具
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:edit')")
    @Log(title = "设计-分段施工措施_特殊工具", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        return toAjax(sjFdsgcsTsgjService.updateSjFdsgcsTsgj(sjFdsgcsTsgj));
    }

    /**
     * 删除设计-分段施工措施_特殊工具
     */
   //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsTsgj:remove')")
    @Log(title = "设计-分段施工措施_特殊工具", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsTsgjService.deleteSjFdsgcsTsgjByIds(ids));
    }
}
