package com.ruoyi.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-井眼轨迹信息对象 sj_jygj_info
 * 
 * @author ruoyi
 * @date 2025-06-26
 */
public class SjJygjInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 轨道类型 */
    @Excel(name = "轨道类型")
    private String gdlx;

    /** 井口横坐标 */
    @Excel(name = "井口横坐标")
    private Double jkhzb;

    /** 井口纵坐标 */
    @Excel(name = "井口纵坐标")
    private Double jkzzb;

    /** 靶点横坐标 */
    @Excel(name = "靶点横坐标")
    private Double bdhzb;

    /** 靶点纵坐标 */
    @Excel(name = "靶点纵坐标")
    private Double bdzzb;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 闭合距 */
    @Excel(name = "闭合距")
    private Double bhj;

    /** 闭合方向 */
    @Excel(name = "闭合方向")
    private Double bhfx;

    /** 靶半径 */
    @Excel(name = "靶半径")
    private Double bbj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setGdlx(String gdlx) 
    {
        this.gdlx = gdlx;
    }

    public String getGdlx() 
    {
        return gdlx;
    }

    public void setJkhzb(Double jkhzb) 
    {
        this.jkhzb = jkhzb;
    }

    public Double getJkhzb() 
    {
        return jkhzb;
    }

    public void setJkzzb(Double jkzzb) 
    {
        this.jkzzb = jkzzb;
    }

    public Double getJkzzb() 
    {
        return jkzzb;
    }

    public void setBdhzb(Double bdhzb) 
    {
        this.bdhzb = bdhzb;
    }

    public Double getBdhzb() 
    {
        return bdhzb;
    }

    public void setBdzzb(Double bdzzb) 
    {
        this.bdzzb = bdzzb;
    }

    public Double getBdzzb() 
    {
        return bdzzb;
    }

    public void setCs(Double cs) 
    {
        this.cs = cs;
    }

    public Double getCs() 
    {
        return cs;
    }

    public void setBhj(Double bhj) 
    {
        this.bhj = bhj;
    }

    public Double getBhj() 
    {
        return bhj;
    }

    public void setBhfx(Double bhfx) 
    {
        this.bhfx = bhfx;
    }

    public Double getBhfx() 
    {
        return bhfx;
    }

    public void setBbj(Double bbj) 
    {
        this.bbj = bbj;
    }

    public Double getBbj() 
    {
        return bbj;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("gdlx", getGdlx())
            .append("jkhzb", getJkhzb())
            .append("jkzzb", getJkzzb())
            .append("bdhzb", getBdhzb())
            .append("bdzzb", getBdzzb())
            .append("cs", getCs())
            .append("bhj", getBhj())
            .append("bhfx", getBhfx())
            .append("bbj", getBbj())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
