package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjZjyFdxnb;
import com.ruoyi.project.zjsgfa.service.ISjZjyFdxnbService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-分段钻井液性能设计Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZjyFdxnb")
public class SjZjyFdxnbController extends BaseController
{
    @Autowired
    private ISjZjyFdxnbService sjZjyFdxnbService;

    /**
     * 查询设计信息-分段钻井液性能设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:list')")
    @GetMapping("/list")
    public AjaxResult list(SjZjyFdxnb sjZjyFdxnb)
    {
//        startPage();
        Map<String, Object> list = sjZjyFdxnbService.selectSjZjyFdxnbList(sjZjyFdxnb);
        return AjaxResult.success(list);
    }

    /**
     * 导出设计信息-分段钻井液性能设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:export')")
    @Log(title = "设计信息-分段钻井液性能设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZjyFdxnb sjZjyFdxnb)
    {
//        List<SjZjyFdxnb> list = sjZjyFdxnbService.selectSjZjyFdxnbList(sjZjyFdxnb);
//        ExcelUtil<SjZjyFdxnb> util = new ExcelUtil<SjZjyFdxnb>(SjZjyFdxnb.class);
//        util.exportExcel(response, list, "设计信息-分段钻井液性能设计数据");
    }

    /**
     * 获取设计信息-分段钻井液性能设计详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZjyFdxnbService.selectSjZjyFdxnbById(id));
    }

    /**
     * 新增设计信息-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:add')")
    @Log(title = "设计信息-分段钻井液性能设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZjyFdxnb sjZjyFdxnb)
    {
        return toAjax(sjZjyFdxnbService.insertSjZjyFdxnb(sjZjyFdxnb));
    }

    /**
     * 修改设计信息-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:edit')")
    @Log(title = "设计信息-分段钻井液性能设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZjyFdxnb sjZjyFdxnb)
    {
        return toAjax(sjZjyFdxnbService.updateSjZjyFdxnb(sjZjyFdxnb));
    }

    /**
     * 删除设计信息-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyFdxnb:remove')")
    @Log(title = "设计信息-分段钻井液性能设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZjyFdxnbService.deleteSjZjyFdxnbByIds(ids));
    }
}
