package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.SecurityUtils;
import com.zjsgfa.common.utils.bean.BeanUtils;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.project.zjsgfa.domain.*;
import com.zjsgfa.project.zjsgfa.mapper.*;
import com.zjsgfa.project.zt.domain.*;
import com.zjsgfa.project.zt.domain.vo.SjInfo;
import com.zjsgfa.project.zt.mapper.JsaaMapper;
import com.zjsgfa.project.zt.service.DjdcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.service.ISjDjjcService;

/**
 * 设计信息-井基础信息Service业务层处理
 * 
 * @author
 * @date 2025-06-23
 */
@Service
public class SjDjjcServiceImpl implements ISjDjjcService 
{
    @Autowired
    private SjDjjcMapper sjDjjcMapper;

    @Autowired
    private DjdcService djdcService;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjZqfxMapper sjZqfxMapper;
    @Autowired
    private SjZtgjsjMapper sjZtgjsjMapper;
    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;
    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjSzfxjgMapper sjSzfxjgMapper;

    @Autowired
    private SjLjtjztMapper sjLjtjztMapper;

    @Autowired
    private SjZtxxMapper sjZtxxMapper;

    @Autowired
    private SjZjcsxxMapper sjZjcsxxMapper;

    @Autowired
    private JsaaMapper jsaaMapper;

    @Autowired
    private SjFdsgcsMapper sjFdsgcsMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;

    @Autowired
    private SjFdsgcsLjzjzhMapper sjFdsgcsLjzjzhMapper;


    @Autowired
    private SgfambMapper sgfambMapper;

    @Autowired
    private SgfambKcxxMapper sgfambKcxxMapper;

    @Autowired
    private SgfambKcSggyMapper sgfambKcSggyMapper;

    @Autowired
    private SjJkzpMapper sjJkzpMapper;

    @Autowired
    private SjHseMapper sjHseMapper;

    @Autowired
    private JcxxJkzpMapper jcxxJkzpMapper;
    @Autowired
    private JcxxHseMapper jcxxHseMapper;


    @Autowired
    private SjSggyGjsbxnyqMapper sjSggyGjsbxnyqMapper;







    /**
     * 查询设计信息-井基础信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 设计信息-井基础信息
     */
    @Override
    public SjDjjc selectSjDjjcById(Long id)
    {
        return sjDjjcMapper.selectSjDjjcById(id);
    }

    /**
     * 查询设计信息-井基础信息列表
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 设计信息-井基础信息
     */
    @Override
    public List<SjDjjc> selectSjDjjcList(SjDjjc sjDjjc)
    {
        return sjDjjcMapper.selectSjDjjcList(sjDjjc);
    }

    /**
     * 新增设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int insertSjDjjc(SjDjjc sjDjjc)
    {




        SjDjjc sjDjjc1 =sjDjjcMapper.selectSjDjjcByJh(sjDjjc.getJh());
        if(sjDjjc1!=null){
            return 3;
        }





        sjDjjc.setCreatedBy(SecurityUtils.getUsername());
        int i = sjDjjcMapper.insertSjDjjc(sjDjjc);

        //施工概要
        SjSggyGjsbxnyq sjSggyGjsbxnyq = new SjSggyGjsbxnyq();
        sjSggyGjsbxnyq.setJh(sjDjjc.getJh());
        sjSggyGjsbxnyqMapper.insertSjSggyGjsbxnyq2(sjSggyGjsbxnyq);
        List<String> sjggjyh= new ArrayList<>();


        //根据区块查询
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> collect = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getQk().equals(sjDjjc.getQk())).collect(Collectors.toList());
        if(collect.size()==0){
            Map<String, List<SgfambKcSggy>> groupedByQk = sgfambKcSggyList.stream()
                    .collect(Collectors.groupingBy(SgfambKcSggy::getQk));
            for(String s:groupedByQk.keySet()){
                collect=groupedByQk.get(s);
                break;
            }
        }

        for (SgfambKcSggy sgfambKcSggy : collect) {
            if (sgfambKcSggy != null) {
                String gjyhxx=sgfambKcSggy.getKc()+"轨迹优化，"+sgfambKcSggy.getGjyh();
                sjggjyh.add(gjyhxx);
                //查询分段施工
                SjFdsgcs sjFdsgcs = new SjFdsgcs();
                sjFdsgcs.setKc(sgfambKcSggy.getKc());
                sjFdsgcs.setJh(sjDjjc.getJh());
                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
                if (sjFdsgcs1 != null) {
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
                } else {
                    sjFdsgcs1 = new SjFdsgcs();
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
                }
                SjZtxx sjZtxx = new SjZtxx();
                sjZtxx.setJh(sjDjjc.getJh());
                sjZtxx.setKc(sgfambKcSggy.getKc());
                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
                if (sjZtxxes.size() > 0) {
                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
                } else {
                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx.setLb("邻井推荐");
                    sjZtxxMapper.insertSjZtxx(sjZtxx);
                }
                SjZjcsxx sjZjcsxx = new SjZjcsxx();
                sjZjcsxx.setJh(sjDjjc.getJh());
                sjZjcsxx.setKc(sgfambKcSggy.getKc());
                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
                if (sjZjcsxxes.size() > 0) {
                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
                } else {
                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
                }
            }
        }
        sjSggyGjsbxnyq.setSjyh(String.join("；", sjggjyh));
        sjSggyGjsbxnyqMapper.updateSjSggyGjsbxnyqByjh(sjSggyGjsbxnyq);


        //井口装置
        List<JcxxJkzp> jcxxJkzps = jcxxJkzpMapper.selectJcxxJkzpList(new JcxxJkzp());
        JcxxJkzp jcxxJkzp = jcxxJkzps.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);

       if(jcxxJkzp!=null){
           SjJkzp sjJkzp =new SjJkzp();
           sjJkzp.setJh(sjDjjc.getJh());
           sjJkzp.setClcb(jcxxJkzp.getClcb());
           sjJkzp.setJlgh(jcxxJkzp.getJlgh());
           sjJkzp.setSyyq(jcxxJkzp.getSyyq());
           sjJkzp.setZjkzz(jcxxJkzp.getZjkzz());
           sjJkzpMapper.insertSjJkzp(sjJkzp);
       }
        List<JcxxHse> jcxxHses = jcxxHseMapper.selectJcxxHseList(new JcxxHse());
        JcxxHse jcxxHse = jcxxHses.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);
        if(jcxxHse!=null){
            SjHse sjHse =new SjHse();
            sjHse.setJh(sjDjjc.getJh());
            sjHse.setHse(jcxxHse.getHse());
            sjHseMapper.insertSjHse(sjHse);
        }


//        if(sjDjjc.getFaid()!=null){
//            SgfambKcSggy sgfambKcSggy = sgfambKcSggyMapper.selectSgfambKcSggyById(sjDjjc.getFaid());
//            if (sgfambKcSggy != null) {
//                //查询分段施工
//                SjFdsgcs sjFdsgcs = new SjFdsgcs();
//                sjFdsgcs.setKc(sgfambKcSggy.getKc());
//                sjFdsgcs.setJh(sjDjjc.getJh());
//                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
//                if (sjFdsgcs1 != null) {
//                    sjFdsgcs1.setJh(sjDjjc.getJh());
//                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
//                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
//                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
//                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
//                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
//                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
//                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
//                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
//                } else {
//                    sjFdsgcs1 = new SjFdsgcs();
//                    sjFdsgcs1.setJh(sjDjjc.getJh());
//                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
//                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
//                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
//                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
//                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
//                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
//                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
//                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
//                }
//                SjZtxx sjZtxx = new SjZtxx();
//                sjZtxx.setJh(sjDjjc.getJh());
//                sjZtxx.setKc(sgfambKcSggy.getKc());
//                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
//                if (sjZtxxes.size() > 0) {
//                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
//                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
//                } else {
//                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZtxx.setLb("邻井推荐");
//                    sjZtxxMapper.insertSjZtxx(sjZtxx);
//                }
//                SjZjcsxx sjZjcsxx = new SjZjcsxx();
//                sjZjcsxx.setJh(sjDjjc.getJh());
//                sjZjcsxx.setKc(sgfambKcSggy.getKc());
//                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
//                if (sjZjcsxxes.size() > 0) {
//                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
//                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
//                } else {
//                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
//                }
//            }



//        }


        return i;

    }

    /**
     * 修改设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    public int updateSjDjjc(SjDjjc sjDjjc)
    {
        sjDjjc.setUpdateTime(DateUtils.getNowDate());
        sjDjjc.setUpdateBy(SecurityUtils.getUsername());
//        if(sjDjjc.getFaid()!=null){
//            List<SgfambKcSggy> sgfambKcSggyList = sgfambKcSggyMapper.selectSgfambKcSggyByZbid(sjDjjc.getFaid());
//            if (sgfambKcSggy != null) {
//                //查询分段施工
//                SjFdsgcs sjFdsgcs = new SjFdsgcs();
//                sjFdsgcs.setKc(sgfambKcSggy.getKc());
//                sjFdsgcs.setJh(sjDjjc.getJh());
//                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
//                if (sjFdsgcs1 != null) {
//                    sjFdsgcs1.setJh(sjDjjc.getJh());
//                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
//                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
//                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
//                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
//                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
//                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
//                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
//                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
//                } else {
//                    sjFdsgcs1 = new SjFdsgcs();
//                    sjFdsgcs1.setJh(sjDjjc.getJh());
//                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
//                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
//                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
//                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
//                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
//                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
//                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
//                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
//                }
//                SjZtxx sjZtxx = new SjZtxx();
//                sjZtxx.setJh(sjDjjc.getJh());
//                sjZtxx.setKc(sgfambKcSggy.getKc());
//                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
//                if (sjZtxxes.size() > 0) {
//                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
//                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
//                } else {
//                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZtxx.setLb("邻井推荐");
//                    sjZtxxMapper.insertSjZtxx(sjZtxx);
//                }
//                SjZjcsxx sjZjcsxx = new SjZjcsxx();
//                sjZjcsxx.setJh(sjDjjc.getJh());
//                sjZjcsxx.setKc(sgfambKcSggy.getKc());
//                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
//                if (sjZjcsxxes.size() > 0) {
//                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
//                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
//                } else {
//                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
//                }
//            }
//        }
        //根据区块查询
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> collect = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getQk().equals(sjDjjc.getQk())).collect(Collectors.toList());
        if(collect.size()==0){
            Map<String, List<SgfambKcSggy>> groupedByQk = sgfambKcSggyList.stream()
                    .collect(Collectors.groupingBy(SgfambKcSggy::getQk));
            for(String s:groupedByQk.keySet()){
                collect=groupedByQk.get(s);
                break;
            }
        }
        for (SgfambKcSggy sgfambKcSggy : collect) {
            if (sgfambKcSggy != null) {
                //查询分段施工
                SjFdsgcs sjFdsgcs = new SjFdsgcs();
                sjFdsgcs.setKc(sgfambKcSggy.getKc());
                sjFdsgcs.setJh(sjDjjc.getJh());
                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
                if (sjFdsgcs1 != null) {
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
                } else {
                    sjFdsgcs1 = new SjFdsgcs();
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(sgfambKcSggy.getZjzh());
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
                }
                SjZtxx sjZtxx = new SjZtxx();
                sjZtxx.setJh(sjDjjc.getJh());
                sjZtxx.setKc(sgfambKcSggy.getKc());
                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
                if (sjZtxxes.size() > 0) {
                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
                } else {
                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx.setLb("邻井推荐");
                    sjZtxxMapper.insertSjZtxx(sjZtxx);
                }
                SjZjcsxx sjZjcsxx = new SjZjcsxx();
                sjZjcsxx.setJh(sjDjjc.getJh());
                sjZjcsxx.setKc(sgfambKcSggy.getKc());
                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
                if (sjZjcsxxes.size() > 0) {
                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
                } else {
                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
                }
            }
        }
        //井口装置
        List<JcxxJkzp> jcxxJkzps = jcxxJkzpMapper.selectJcxxJkzpList(new JcxxJkzp());
        JcxxJkzp jcxxJkzp = jcxxJkzps.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);

        if(jcxxJkzp!=null){
            SjJkzp sjJkzp =new SjJkzp();
            sjJkzp.setJh(sjDjjc.getJh());
            sjJkzp.setClcb(jcxxJkzp.getClcb());
            sjJkzp.setJlgh(jcxxJkzp.getJlgh());
            sjJkzp.setSyyq(jcxxJkzp.getSyyq());
            sjJkzp.setZjkzz(jcxxJkzp.getZjkzz());
            sjJkzpMapper.insertSjJkzp(sjJkzp);
        }
        List<JcxxHse> jcxxHses = jcxxHseMapper.selectJcxxHseList(new JcxxHse());
        JcxxHse jcxxHse = jcxxHses.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);
        if(jcxxHse!=null){
            SjHse sjHse =new SjHse();
            sjHse.setJh(sjDjjc.getJh());
            sjHse.setHse(jcxxHse.getHse());
            sjHseMapper.insertSjHse(sjHse);
        }
        return sjDjjcMapper.updateSjDjjc(sjDjjc);
    }

    /**
     * 批量删除设计信息-井基础信息
     * 
     * @param ids 需要删除的设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcByIds(Long[] ids)
    {


        int i = sjDjjcMapper.deleteSjDjjcByIds(ids);



        return i;
    }

    /**
     * 删除设计信息-井基础信息信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcById(Long id)
    {
        SjDjjc sjDjjc = selectSjDjjcById(id);

        sjDjjcMapper.batchDeleteByJhPrefix(sjDjjc.getJh());

        int i = sjDjjcMapper.deleteSjDjjcById(id);

        return i;
    }

    @Override
    public AjaxResult saveLjzl(CommonParam param) throws Exception {
        String jh = param.getSjjh();
        String ljjh = param.getJh();
        SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcByJh(jh);
        param.setQk(sjDjjc.getQk());
        param.setJkhzb(sjDjjc.getJkhzb());
        param.setJkzzb(sjDjjc.getJkzzb());
        param.setJdhzb(sjDjjc.getJdhzb());
        param.setJdzzb(sjDjjc.getJdzzb());
        param.setJh(null);

        //保存邻井
//        List<Ljjw> ljjwList = djdcService.getLjjwList(param);
//        List<SjLjjw> sjLjjwList=new ArrayList<>();
//        ljjwList.forEach(item->{
//            SjLjjw sjLjjw=new SjLjjw();
//            BeanUtils.copyProperties(item,sjLjjw);
//            sjLjjw.setJh(jh);
//            sjLjjw.setLjjh(item.getJh());
//            sjLjjwList.add(sjLjjw);
//        });
//        if(sjLjjwList.size()>0){
//            sjLjjwMapper.deleteSjLjjwByJh(jh);
//            sjLjjwMapper.insertSjLjjwBatch(sjLjjwList);
//
//        }
        param.setJkhzb(null);
        param.setJkzzb(null);
        param.setJdhzb(null);
        param.setJdzzb(null);
        param.setJh(ljjh);
        //周期分析
        List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param);
        List<SjZqfx> sjZqfxList=new ArrayList<>();
        zqshfxList.forEach(item->{
            SjZqfx sjZqfx=new SjZqfx();
            BeanUtils.copyProperties(item,sjZqfx);
            sjZqfx.setJh(jh);
            sjZqfx.setLjjh(item.getJh());
            sjZqfx.setCw(item.getCw());
            sjZqfx.setZjzq(item.getZjzq());
            sjZqfx.setZjycsl(item.getZjycsl());
            sjZqfx.setZjsczq(item.getZjsczq());
            sjZqfx.setZjsl(item.getZjsl());
            sjZqfx.setZwzq(item.getZwzq());
            sjZqfx.setWjycsl(item.getWjycsl());
            sjZqfx.setWjsczq(item.getWjsczq());
            sjZqfx.setZjycms(item.getZjycms());
            sjZqfx.setWjycms(item.getWjycms());
            sjZqfxList.add(sjZqfx);
        });
        if(sjZqfxList.size()>0){
            sjZqfxMapper.deleteSjZqfxByJh(jh);
            sjZqfxMapper.insertSjZqfxBatch(sjZqfxList);
        }
        //钻头关键数据
        List<Djjc> djjcList = djdcService.getDjjcList(param);
        List<SjZtgjsj> sjZtgjsjList=new ArrayList<>();

        djjcList.forEach(item->{
            SjZtgjsj sjZtgjsj=new SjZtgjsj();
            BeanUtils.copyProperties(item,sjZtgjsj);
            sjZtgjsj.setJh(jh);
            sjZtgjsj.setLjjh(item.getJh());
            sjZtgjsjList.add(sjZtgjsj);
        });
        if(sjZtgjsjList.size()>0){
            sjZtgjsjMapper.deleteSjZtgjsjByJh(jh);
            sjZtgjsjMapper.insertSjZtgjsjBatch(sjZtgjsjList);
        }
        //区块钻头分析
        List<DjZtfx> djZtfxList = djdcService.getDjZtfxList(param);
        List<SjQkztfx> sjQkztfxList=new ArrayList<>();
        djZtfxList.forEach(item->{
            SjQkztfx sjQkztfx=new SjQkztfx();
            BeanUtils.copyProperties(item,sjQkztfx);
            sjQkztfx.setJh(jh);
            sjQkztfxList.add(sjQkztfx);
        });
        if(sjQkztfxList.size()>0){
            sjQkztfxMapper.deleteSjQkztfxByJh(jh);
            sjQkztfxMapper.insertSjQkztfxBatch(sjQkztfxList);
        }

        //实钻分析结果
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjInfo> sjInfoList=new ArrayList<>();
        for(int i=0;i<sjJsjgList.size();i++){
            SjInfo sjInfo =new SjInfo();
            sjInfo.setKc((i+1)+"");
            sjInfo.setZtcc(sjJsjgList.get(i).getZtzj());
            sjInfoList.add(sjInfo);
        }
        param.setSj(sjInfoList);
        List<LjSzfxjg> ljSzfxjgList=djdcService.getSztfxjgList(djZtfxList,djjcList,param);
        List<SjSzfxjg> sjSzfxjgList=new ArrayList<>();
        ljSzfxjgList.forEach(item->{
            SjSzfxjg sjSzfxjg=new SjSzfxjg();
            BeanUtils.copyProperties(item,sjSzfxjg);
            sjSzfxjg.setJh(jh);
            sjSzfxjgList.add(sjSzfxjg);
        });
        if(sjSzfxjgList.size()>0){
            sjSzfxjgMapper.deleteSjSzfxjgByJh(jh);
            sjSzfxjgMapper.insertSjSzfxjgBatch(sjSzfxjgList);
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult saveZtxh(CommonParam param) {
        String jh = param.getSjjh();
        SjZtgjsj sjZtgjsj = new SjZtgjsj();
        sjZtgjsj.setJh(jh);
        List<SjZtgjsj> sjZtgjsjList = sjZtgjsjMapper.selectSjZtgjsjList(sjZtgjsj);
        SjJsjg sjJsjg = new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjLjtjzt> sjLjtjztList=new ArrayList<>();
        double ksjs=0;
        for(int i=0;i<sjJsjgList.size();i++){
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if(i==0){
                ksjs=0;;
            }else {
                ksjs=sjJsjgList.get(i-1).getJs();
            }
            final int kc=i+1;
            //查询钻头关键数据
            List<SjZtgjsj> collect = sjZtgjsjList.stream()
                    .filter(it -> String.valueOf(kc).equals(it.getKc()))
                    .sorted(Comparator.comparing(SjZtgjsj::getJxzs,
                                    Comparator.nullsLast(Comparator.reverseOrder())))
                    .collect(Collectors.toList());
            if(collect.size()>3){
                collect=collect.subList(0,3);
            }
            SjZtxx sjZtxx =new SjZtxx();
            collect.forEach(it->{
                SjLjtjzt sjLjtjzt=new SjLjtjzt();
                sjLjtjzt.setJh(jh);
                sjLjtjzt.setLjjh(it.getLjjh());
                sjLjtjzt.setKc(sjJsjg1.getKc());
                sjLjtjzt.setCc(it.getZtcc());
                sjLjtjzt.setZtxh(it.getZtxh());
                sjLjtjzt.setSy(it.getPz());
                sjLjtjzt.setZjjd(it.getJd());
                sjLjtjzt.setCw(it.getCw());
                sjLjtjzt.setJxzs(it.getJxzs());
                //查询厂家
                Djjc djjc = new Djjc();
                djjc.setJh(it.getLjjh());
                djjc.setKc(kc+"");
                djjc.setJd(it.getJd());
                djjc.setJxzs(it.getJxzs());
                Djjc djjc1=djdcService.selectZtsj(djjc);
                if(djjc1!=null){
                    sjLjtjzt.setCj(djjc1.getCj());
                }
                sjLjtjztList.add(sjLjtjzt);
            });
//            if(collect.size()>0){
//                SjZtgjsj sjZtgjsj1 = collect.get(0);
//                sjZtxx.setJh(jh);
//                sjZtxx.setLb("邻井推荐");
//                sjZtxx.setKc(sjJsjg1.getKc());
//                sjZtxx.setZtxh(collect.get(0).getZtxh());
//                sjZtxxMapper.deleteSjZtxxByZtxx(sjZtxx);
//                sjZtxxMapper.insertSjZtxx(sjZtxx);
//                //施工参数
//                SjZjcsxx sjZjcsxx =new SjZjcsxx();
//                sjZjcsxx.setJh(jh);
//                sjZjcsxx.setKc(sjJsjg1.getKc());
//                sjZjcsxx.setJd(ksjs+"-"+sjJsjg1.getJs());
//                sjZjcsxx.setZtxh(sjZtgjsj1.getZtxh());
//                sjZjcsxx.setCc(sjZtgjsj1.getZtcc()+"");
//                sjZjcsxx.setSy(sjZtgjsj1.getPz()+"");
//                sjZjcsxx.setZjymd(sjZtgjsj1.getZjymd()+"");
//                sjZjcsxx.setZjpl(sjZtgjsj1.getPl()+"");
//                sjZjcsxx.setZjby(sjZtgjsj1.getLgby()+"");
//                //查询厂家
//                Djjc djjc = new Djjc();
//                djjc.setJh(sjZtgjsj1.getLjjh());
//                djjc.setKc(kc+"");
//                djjc.setJd(sjZtgjsj1.getJd());
//                djjc.setJxzs(sjZtgjsj1.getJxzs());
//                Djjc djjc1=djdcService.selectZtsj(djjc);
//                if(djjc1!=null){
//                    sjZjcsxx.setCj(djjc1.getCj());
//                    sjZjcsxx.setYj(djjc1.getZtyj()+"");
//                    sjZjcsxx.setZjzy(djjc1.getZy());
//                    sjZjcsxx.setZjzs(djjc1.getZs()+"");
//                }
//                sjZjcsxxMapper.deleteSjZjcsxxByZjcsxx(sjZjcsxx);
//                sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
//                Jsfa jsfa =new Jsfa();
//                jsfa.setJh(sjZtgjsj1.getLjjh());
//                jsfa.setZjjd(sjZtgjsj1.getJd());
//                Jsfa jsfa1=jsaaMapper.selectJsfa(jsfa);
//                String zjzh="";
//                if(jsfa1!=null){
//                    zjzh = jsfa1.getZjzh();
//                }
//                SjFdsgcs sjFdsgcs =new SjFdsgcs();
//                sjFdsgcs.setJh(jh);
//                sjFdsgcs.setKc(sjJsjg1.getKc());
//                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
//                if(sjFdsgcs1!=null){
//                    sjFdsgcs1.setZjzh(zjzh);
//                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
//                }else {
//                    sjFdsgcs1=new SjFdsgcs();
//                    sjFdsgcs1.setJh(jh);
//                    sjFdsgcs1.setKc(sjJsjg1.getKc());
//                    sjFdsgcs1.setZjzh(zjzh);
//                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
//                }
//                //概要施工参数
//                SjSggyZjzhcs sjSggyZjzhcs=new SjSggyZjzhcs();
//                sjSggyZjzhcs.setJh(jh);
//                sjSggyZjzhcs.setKc(sjJsjg1.getKc());
//                sjSggyZjzhcs.setJd(ksjs+"-"+sjJsjg1.getJs());
//                sjSggyZjzhcs.setZtxh(sjZtgjsj1.getZtxh());
//                sjSggyZjzhcs.setCc(sjZtgjsj1.getZtcc()+"");
//                sjSggyZjzhcs.setSy(sjZtgjsj1.getPz()+"");
//                sjSggyZjzhcs.setZjymd(sjZtgjsj1.getZjymd()+"");
//                sjSggyZjzhcs.setZjpl(sjZtgjsj1.getPl()+"");
//                sjSggyZjzhcs.setZjby(sjZtgjsj1.getLgby()+"");
//                sjSggyZjzhcs.setZjjg(zjzh);
//                if(djjc1!=null){
//                    sjSggyZjzhcs.setCj(djjc1.getCj());
//                    sjSggyZjzhcs.setYj(djjc1.getZtyj()+"");
//                    sjSggyZjzhcs.setZjzy(djjc1.getZy());
//                    sjSggyZjzhcs.setZjzs(djjc1.getZs()+"");
//                }
//                sjSggyZjzhcsMapper.deleteSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
//                sjSggyZjzhcsMapper.insertSjSggyZjzhcs(sjSggyZjzhcs);
//            }
        }
        if(sjLjtjztList.size()>0){
            sjLjtjztMapper.deleteSjLjtjztByJh(jh);
            sjLjtjztMapper.insertSjLjtjztBatch(sjLjtjztList);
        }

        return AjaxResult.success("计算成功");
    }

    @Override
    public AjaxResult saveZjzh(CommonParam param) {

        //查询邻井
        SjLjjw sjLjjw=new SjLjjw();
        sjLjjw.setJh(param.getJh());
        List<SjLjjw> sjLjjwList = sjLjjwMapper.selectSjLjjwList(sjLjjw);
        if(sjLjjwList.size()>0){
            CommonParam param1=new CommonParam();
            String[] collectArray = sjLjjwList.stream()
                    .map(SjLjjw::getLjjh)
                    .toArray(String[]::new);
            param1.setJhs(collectArray);
            List<DjZjzhfx> zjzhfxList = djdcService.getZjzhfxList(param1);
            zjzhfxList=zjzhfxList.stream().filter(it->it.getZb()!=null).sorted(Comparator.comparing(DjZjzhfx::getZb).reversed()).collect(Collectors.toList());
            if(zjzhfxList.size()>3){
                zjzhfxList=zjzhfxList.subList(0,3);
            }
            List<SjFdsgcsLjzjzh> sjFdsgcsLjzjzhList = new ArrayList<>();
            for (DjZjzhfx it:zjzhfxList) {
                SjFdsgcsLjzjzh sjFdsgcsLjzjzh = new SjFdsgcsLjzjzh();
                sjFdsgcsLjzjzh.setJh(param.getJh());
                sjFdsgcsLjzjzh.setKc(it.getKc());
                sjFdsgcsLjzjzh.setLjjh(it.getJh());
                sjFdsgcsLjzjzh.setZjzh(it.getZjzh());
                sjFdsgcsLjzjzh.setSx(it.getZb());
                sjFdsgcsLjzjzh.setJc(it.getJc());
                sjFdsgcsLjzjzhList.add(sjFdsgcsLjzjzh);
            }
            if(sjFdsgcsLjzjzhList.size()>0){
                sjFdsgcsLjzjzhMapper.deleteSjFdsgcsLjzjzhByJh(param.getJh());
                sjFdsgcsLjzjzhMapper.insertSjFdsgcsLjzjzhBatch(sjFdsgcsLjzjzhList);
            }
        }

        return AjaxResult.success("计算成功");
    }


}
