package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.Cxtj;

/**
 * 查询条件Mapper接口
 * 
 * @author ruoyi
 * @date 2025-09-12
 */
public interface CxtjMapper 
{
    /**
     * 查询查询条件
     * 
     * @param id 查询条件主键
     * @return 查询条件
     */
    public Cxtj selectCxtjById(Long id);

    /**
     * 查询查询条件列表
     * 
     * @param cxtj 查询条件
     * @return 查询条件集合
     */
    public List<Cxtj> selectCxtjList(Cxtj cxtj);

    /**
     * 新增查询条件
     * 
     * @param cxtj 查询条件
     * @return 结果
     */
    public int insertCxtj(Cxtj cxtj);

    /**
     * 修改查询条件
     * 
     * @param cxtj 查询条件
     * @return 结果
     */
    public int updateCxtj(Cxtj cxtj);

    /**
     * 删除查询条件
     * 
     * @param id 查询条件主键
     * @return 结果
     */
    public int deleteCxtjById(Long id);

    /**
     * 批量删除查询条件
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCxtjByIds(Long[] ids);
}
