package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsLjzjzh;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsLjzjzhService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-分段施工措施-邻井钻具组合Controller
 * 
 * @author ruoyi
 * @date 2025-09-03
 */
@RestController
@RequestMapping("/system/sjFdsgcsLjzjzh")
public class SjFdsgcsLjzjzhController extends BaseController
{
    @Autowired
    private ISjFdsgcsLjzjzhService sjFdsgcsLjzjzhService;

    /**
     * 查询设计信息-分段施工措施-邻井钻具组合列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsLjzjzh sjFdsgcsLjzjzh)
    {
        startPage();
        List<SjFdsgcsLjzjzh> list = sjFdsgcsLjzjzhService.selectSjFdsgcsLjzjzhList(sjFdsgcsLjzjzh);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-分段施工措施-邻井钻具组合列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:export')")
    @Log(title = "设计信息-分段施工措施-邻井钻具组合", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsLjzjzh sjFdsgcsLjzjzh)
    {
        List<SjFdsgcsLjzjzh> list = sjFdsgcsLjzjzhService.selectSjFdsgcsLjzjzhList(sjFdsgcsLjzjzh);
        ExcelUtil<SjFdsgcsLjzjzh> util = new ExcelUtil<SjFdsgcsLjzjzh>(SjFdsgcsLjzjzh.class);
        util.exportExcel(response, list, "设计信息-分段施工措施-邻井钻具组合数据");
    }

    /**
     * 获取设计信息-分段施工措施-邻井钻具组合详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsLjzjzhService.selectSjFdsgcsLjzjzhById(id));
    }

    /**
     * 新增设计信息-分段施工措施-邻井钻具组合
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:add')")
    @Log(title = "设计信息-分段施工措施-邻井钻具组合", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsLjzjzh sjFdsgcsLjzjzh)
    {
        return toAjax(sjFdsgcsLjzjzhService.insertSjFdsgcsLjzjzh(sjFdsgcsLjzjzh));
    }

    /**
     * 修改设计信息-分段施工措施-邻井钻具组合
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:edit')")
    @Log(title = "设计信息-分段施工措施-邻井钻具组合", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsLjzjzh sjFdsgcsLjzjzh)
    {
        return toAjax(sjFdsgcsLjzjzhService.updateSjFdsgcsLjzjzh(sjFdsgcsLjzjzh));
    }

    /**
     * 删除设计信息-分段施工措施-邻井钻具组合
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsLjzjzh:remove')")
    @Log(title = "设计信息-分段施工措施-邻井钻具组合", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsLjzjzhService.deleteSjFdsgcsLjzjzhByIds(ids));
    }
}
