package com.ruoyi.project.zt.mapper;

import java.util.List;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zt.domain.LjZjzhfx;

/**
 * 邻井-钻具组合分析Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-02
 */
@DataSource(value = DataSourceType.SLAVE)
public interface LjZjzhfxMapper 
{
    /**
     * 查询邻井-钻具组合分析
     * 
     * @param id 邻井-钻具组合分析主键
     * @return 邻井-钻具组合分析
     */
    public LjZjzhfx selectLjZjzhfxById(Long id);

    /**
     * 查询邻井-钻具组合分析列表
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 邻井-钻具组合分析集合
     */
    public List<LjZjzhfx> selectLjZjzhfxList(LjZjzhfx ljZjzhfx);

    /**
     * 新增邻井-钻具组合分析
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 结果
     */
    public int insertLjZjzhfx(LjZjzhfx ljZjzhfx);

    /**
     * 修改邻井-钻具组合分析
     * 
     * @param ljZjzhfx 邻井-钻具组合分析
     * @return 结果
     */
    public int updateLjZjzhfx(LjZjzhfx ljZjzhfx);

    /**
     * 删除邻井-钻具组合分析
     * 
     * @param id 邻井-钻具组合分析主键
     * @return 结果
     */
    public int deleteLjZjzhfxById(Long id);

    /**
     * 批量删除邻井-钻具组合分析
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteLjZjzhfxByIds(Long[] ids);

    int batchLjZjzhfx(List<LjZjzhfx> zjzhfxList);


}
