package com.ruoyi.project.zt.mapper;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zt.domain.Jsaa;
import com.ruoyi.project.zt.domain.Jsfa;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 基础数据Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-10
 */
@Mapper
@DataSource(value = DataSourceType.SLAVE)
public interface JsaaMapper 
{
    /**
     * 查询基础数据
     * 
     * @param jh 基础数据主键
     * @return 基础数据
     */
    public Jsaa selectJsaaByJh(String jh);

    /**
     * 查询基础数据列表
     * 
     * @param jsaa 基础数据
     * @return 基础数据集合
     */
    public List<Jsaa> selectJsaaList(Jsaa jsaa);

    /**
     * 新增基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    public int insertJsaa(Jsaa jsaa);

    /**
     * 修改基础数据
     * 
     * @param jsaa 基础数据
     * @return 结果
     */
    public int updateJsaa(Jsaa jsaa);

    /**
     * 删除基础数据
     * 
     * @param jh 基础数据主键
     * @return 结果
     */
    public int deleteJsaaByJh(String jh);

    /**
     * 批量删除基础数据
     * 
     * @param jhs 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteJsaaByJhs(String[] jhs);

    List<Jsaa> selectQklist(Jsaa jsaa);


    Jsfa selectJsfa(Jsfa jsfa);

}
