package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjFdsgcsDcyxMapper;
import com.ruoyi.project.zjsgfa.domain.SjFdsgcsDcyx;
import com.ruoyi.project.zjsgfa.service.ISjFdsgcsDcyxService;

/**
 * 设计-分段施工措施-地层岩性Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
@Service
public class SjFdsgcsDcyxServiceImpl implements ISjFdsgcsDcyxService 
{
    @Autowired
    private SjFdsgcsDcyxMapper sjFdsgcsDcyxMapper;

    /**
     * 查询设计-分段施工措施-地层岩性
     * 
     * @param id 设计-分段施工措施-地层岩性主键
     * @return 设计-分段施工措施-地层岩性
     */
    @Override
    public SjFdsgcsDcyx selectSjFdsgcsDcyxById(Long id)
    {
        return sjFdsgcsDcyxMapper.selectSjFdsgcsDcyxById(id);
    }

    /**
     * 查询设计-分段施工措施-地层岩性列表
     * 
     * @param sjFdsgcsDcyx 设计-分段施工措施-地层岩性
     * @return 设计-分段施工措施-地层岩性
     */
    @Override
    public List<SjFdsgcsDcyx> selectSjFdsgcsDcyxList(SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        return sjFdsgcsDcyxMapper.selectSjFdsgcsDcyxList(sjFdsgcsDcyx);
    }

    /**
     * 新增设计-分段施工措施-地层岩性
     * 
     * @param sjFdsgcsDcyx 设计-分段施工措施-地层岩性
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsDcyx(SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        return sjFdsgcsDcyxMapper.insertSjFdsgcsDcyx(sjFdsgcsDcyx);
    }

    /**
     * 修改设计-分段施工措施-地层岩性
     * 
     * @param sjFdsgcsDcyx 设计-分段施工措施-地层岩性
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsDcyx(SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        return sjFdsgcsDcyxMapper.updateSjFdsgcsDcyx(sjFdsgcsDcyx);
    }

    /**
     * 批量删除设计-分段施工措施-地层岩性
     * 
     * @param ids 需要删除的设计-分段施工措施-地层岩性主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcyxByIds(Long[] ids)
    {
        return sjFdsgcsDcyxMapper.deleteSjFdsgcsDcyxByIds(ids);
    }

    /**
     * 删除设计-分段施工措施-地层岩性信息
     * 
     * @param id 设计-分段施工措施-地层岩性主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcyxById(Long id)
    {
        return sjFdsgcsDcyxMapper.deleteSjFdsgcsDcyxById(id);
    }
}
