package com.zjsgfa.project.zjsgfa.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjTgTgxnsj;
import com.zjsgfa.project.zjsgfa.service.ISjTgTgxnsjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-套管性能数据Controller
 * 
 * @author
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjTgTgxnsj")
public class SjTgTgxnsjController extends BaseController
{
    @Autowired
    private ISjTgTgxnsjService sjTgTgxnsjService;

    /**
     * 查询设计信息-套管性能数据列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjTgTgxnsj sjTgTgxnsj)
    {
//        startPage();
        List<SjTgTgxnsj> list = sjTgTgxnsjService.selectSjTgTgxnsjList(sjTgTgxnsj);
        return getDataTable(list);
    }

    @GetMapping("/getList")
    public AjaxResult getList(SjTgTgxnsj sjTgTgxnsj)
    {
//        startPage();
        List<SjTgTgxnsj> list = sjTgTgxnsjService.selectSjTgTgxnsjList(sjTgTgxnsj);
        Map<String, Object> map = new HashMap<>();
        map.put("jh", "井号");
        map.put("wj", "外径");
        map.put("gj", "钢级");
        map.put("bh", "壁厚");
        map.put("kx", "扣型");
        map.put("mmzl", "每米重量");
        map.put("jgwj", "接箍外径");
        map.put("klqd", "抗拉强度");
        map.put("kjqd", "抗挤强度");
        map.put("knyqd", "抗内压强度");
        return AjaxResult.success(list,map);
    }

    /**
     * 导出设计信息-套管性能数据列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:export')")
    @Log(title = "设计信息-套管性能数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjTgTgxnsj sjTgTgxnsj)
    {
        List<SjTgTgxnsj> list = sjTgTgxnsjService.selectSjTgTgxnsjList(sjTgTgxnsj);
        ExcelUtil<SjTgTgxnsj> util = new ExcelUtil<SjTgTgxnsj>(SjTgTgxnsj.class);
        util.exportExcel(response, list, "设计信息-套管性能数据数据");
    }

    /**
     * 获取设计信息-套管性能数据详细信息
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjTgTgxnsjService.selectSjTgTgxnsjById(id));
    }

    /**
     * 新增设计信息-套管性能数据
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:add')")
    @Log(title = "设计信息-套管性能数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjTgTgxnsj sjTgTgxnsj)
    {
        return toAjax(sjTgTgxnsjService.insertSjTgTgxnsj(sjTgTgxnsj));
    }

    /**
     * 修改设计信息-套管性能数据
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:edit')")
    @Log(title = "设计信息-套管性能数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjTgTgxnsj sjTgTgxnsj)
    {
        return toAjax(sjTgTgxnsjService.updateSjTgTgxnsj(sjTgTgxnsj));
    }

    /**
     * 删除设计信息-套管性能数据
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgxnsj:remove')")
    @Log(title = "设计信息-套管性能数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjTgTgxnsjService.deleteSjTgTgxnsjByIds(ids));
    }
}
