package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjLjjw;
import com.zjsgfa.project.zjsgfa.service.ISjLjjwService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-邻井井位Controller
 * 
 * @author
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjLjjw")
public class SjLjjwController extends BaseController
{
    @Autowired
    private ISjLjjwService sjLjjwService;

    /**
     * 查询设计-邻井井位列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjLjjw sjLjjw)
    {
//        startPage();
        List<SjLjjw> list = sjLjjwService.selectSjLjjwList(sjLjjw);
        return getDataTable(list);
    }

    /**
     * 导出设计-邻井井位列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:export')")
    @Log(title = "设计-邻井井位", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjLjjw sjLjjw)
    {
        List<SjLjjw> list = sjLjjwService.selectSjLjjwList(sjLjjw);
        ExcelUtil<SjLjjw> util = new ExcelUtil<SjLjjw>(SjLjjw.class);
        util.exportExcel(response, list, "设计-邻井井位数据");
    }

    /**
     * 获取设计-邻井井位详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjLjjwService.selectSjLjjwById(id));
    }

    /**
     * 新增设计-邻井井位
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:add')")
    @Log(title = "设计-邻井井位", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjLjjw sjLjjw)
    {
        return toAjax(sjLjjwService.insertSjLjjw(sjLjjw));
    }

    @PostMapping("/pladd")
    public AjaxResult pladd(@RequestBody List<SjLjjw> list)
    {
        return toAjax(sjLjjwService.insertSjLjjwBatch(list));
    }

    /**
     * 修改设计-邻井井位
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:edit')")
    @Log(title = "设计-邻井井位", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjLjjw sjLjjw)
    {
        return toAjax(sjLjjwService.updateSjLjjw(sjLjjw));
    }

    /**
     * 删除设计-邻井井位
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjjw:remove')")
    @Log(title = "设计-邻井井位", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjLjjwService.deleteSjLjjwByIds(ids));
    }

    @PostMapping("/addAll")
    public AjaxResult addAll(@RequestBody List<SjLjjw> list)
    {
        if(list.size()==0){
            return AjaxResult.error();
        }
        sjLjjwService.deleteSjLjjwByJh(list.get(0).getJh());
        return toAjax(sjLjjwService.insertSjLjjwBatch(list));
    }





}
