package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.project.zjsgfa.domain.*;
import com.zjsgfa.project.zjsgfa.mapper.*;
import com.zjsgfa.project.zjsgfa.util.CxszhUtil;
import com.zjsgfa.project.zt.domain.*;
import com.zjsgfa.project.zt.mapper.DjdcInfoMapper;
import com.zjsgfa.project.zt.mapper.JsqaMapper;
import com.zjsgfa.project.zt.service.DjdcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsService;

/**
 * 设计-分段施工措施Service业务层处理
 * 
 * @author
 * @date 2025-08-06
 */
@Service
public class SjFdsgcsServiceImpl implements ISjFdsgcsService 
{
    @Autowired
    private SjFdsgcsMapper sjFdsgcsMapper;

    @Autowired
    private SjDjjcMapper sjDjjcMapper;
    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;

    @Autowired
    private SjFdsgcsDcyxMapper sjFdsgcsDcyxMapper;

    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;

    @Autowired
    private JsqaMapper jsqaMapper;

    @Autowired
    private ClFxsbMapper clFxsbMapper;

    @Autowired
    private SjZysxMapper sjZysxMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;


    @Autowired
    private SjSggyGjsbxnyqMapper sjSggyGjsbxnyqMapper;
    @Autowired
    private DjdcService djdcService;

    @Autowired
    private SgfambKcSggyMapper sgfambKcSggyMapper;
    @Autowired
    private DjdcInfoMapper djdcInfoMapper;
    @Autowired
    private SjJygjGdfdcsMapper sjJygjGdfdcsMapper;

    /**
     * 查询设计-分段施工措施
     * 
     * @param id 设计-分段施工措施主键
     * @return 设计-分段施工措施
     */
    @Override
    public SjFdsgcs selectSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.selectSjFdsgcsById(id);
    }

    /**
     * 查询设计-分段施工措施列表
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 设计-分段施工措施
     */
    @Override
    public List<SjFdsgcs> selectSjFdsgcsList(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.selectSjFdsgcsList(sjFdsgcs);
    }

    /**
     * 新增设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int insertSjFdsgcs(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
    }

    /**
     * 修改设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int updateSjFdsgcs(SjFdsgcs sjFdsgcs)
    {

        if(StringUtils.isNotEmpty(sjFdsgcs.getGjfx())){
            String s = new String(Base64.decode(sjFdsgcs.getGjfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjfx(s);
        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getGjyh())){
            String s = new String(Base64.decode(sjFdsgcs.getGjyh()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjyh(s);
            //保存到施工概要
            SjSggyGjsbxnyq sjSggyGjsbxnyq = new SjSggyGjsbxnyq();
            sjSggyGjsbxnyq.setJh(sjFdsgcs.getJh());
            List<SjSggyGjsbxnyq> sjSggyGjsbxnyqs = sjSggyGjsbxnyqMapper.selectSjSggyGjsbxnyqList(sjSggyGjsbxnyq);
            SjFdsgcs sjFdsgcs1=new SjFdsgcs();
            sjFdsgcs1.setJh(sjFdsgcs.getJh());
            List<SjFdsgcs> sjFdsgcs2 = sjFdsgcsMapper.selectSjFdsgcsList(sjFdsgcs1);

            List<String> strs=new ArrayList<>();
            sjFdsgcs2.forEach(item->{
                if(StringUtils.isNotEmpty(item.getGjyh())){
                    if(item.getKc().equals(sjFdsgcs.getKc())){
                        strs.add("<p>"+item.getKc()+"</p>:"+s);
                    }else {
                        strs.add("<p>"+item.getKc()+"</p>:"+item.getGjyh());
                    }
                }
            });


            if(sjSggyGjsbxnyqs.size()>0){
                SjSggyGjsbxnyq sjSggyGjsbxnyq1 = sjSggyGjsbxnyqs.get(0);

                sjSggyGjsbxnyq1.setSjyh(String.join("；",strs.stream().distinct().collect(Collectors.toList())));
                sjSggyGjsbxnyqMapper.updateSjSggyGjsbxnyq(sjSggyGjsbxnyq1);
            }else {
                sjSggyGjsbxnyq.setSjyh(String.join("；",strs.stream().distinct().collect(Collectors.toList())));
                sjSggyGjsbxnyqMapper.insertSjSggyGjsbxnyq(sjSggyGjsbxnyq);
            }


        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getDcyl())){
            String s = new String(Base64.decode(sjFdsgcs.getDcyl()), StandardCharsets.UTF_8);
            sjFdsgcs.setDcyl(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZyfx())){
            String s = new String(Base64.decode(sjFdsgcs.getZyfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZyfx(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getFxgkcs())){
            String s = new String(Base64.decode(sjFdsgcs.getFxgkcs()), StandardCharsets.UTF_8);
            sjFdsgcs.setFxgkcs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjycs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjycs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjycs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjgccs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjgccs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjgccs(s);
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzh())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzh()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzh(s);
            //查询井段信息
            SjJsjg sjJsjg = new SjJsjg();
            sjJsjg.setJh(sjFdsgcs.getJh());
            List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
            double ksjs=0;
            String jd ="";
            for(int i=0;i<sjJsjgList.size();i++) {
                SjJsjg sjJsjg1 = sjJsjgList.get(i);
                if(sjFdsgcs.getKc().equals(sjJsjg1.getKc())){
                    if (i == 0) {
                        ksjs = 0;
                    } else {
                        ksjs = sjJsjgList.get(i - 1).getJs();
                    }
                    jd=ksjs+"-"+sjJsjg1.getJs();

                }
            }
            SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
            sjSggyZjzhcs.setJh(sjFdsgcs.getJh());
            sjSggyZjzhcs.setKc(sjFdsgcs.getKc());
            SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
            if(sjSggyZjzhcs1!=null){
                sjSggyZjzhcs1.setZjjg(s);
                sjSggyZjzhcs1.setJd(jd);
                sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
            }else {
                sjSggyZjzhcs1=new SjSggyZjzhcs();
                sjSggyZjzhcs1.setJh(sjFdsgcs.getJh());
                sjSggyZjzhcs1.setKc(sjFdsgcs.getKc());
                sjSggyZjzhcs1.setJd(jd);
                sjSggyZjzhcs1.setZjjg(s);
                sjSggyZjzhcsMapper.insertSjSggyZjzhcs(sjSggyZjzhcs1);
            }
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzhzysx())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzhzysx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzhzysx(s);
        }


        return sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
    }

    /**
     * 批量删除设计-分段施工措施
     * 
     * @param ids 需要删除的设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsByIds(Long[] ids)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsByIds(ids);
    }

    /**
     * 删除设计-分段施工措施信息
     * 
     * @param id 设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsById(id);
    }

    @Override
    public void jsfdsgcs(SjFdsgcs sjFdsgcs) {
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(sjFdsgcs.getJh());
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        //查询邻井
        SjLjjw sjLjjw =new SjLjjw();
        sjLjjw.setJh(sjFdsgcs.getJh());
        List<SjLjjw> sjLjjwList = sjLjjwMapper.selectSjLjjwList(sjLjjw);
        SjQkztfx sjQkztfx =new SjQkztfx();
        sjQkztfx.setJh(sjFdsgcs.getJh());
        List<SjQkztfx> sjQkztfxes = sjQkztfxMapper.selectSjQkztfxList(sjQkztfx);
        List<ClFxsb> clFxsbList = clFxsbMapper.selectClFxsbList(new ClFxsb());

        SjJygjGdsjgdcs sjJygjGdsjgdcs=new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(sjFdsgcs.getJh());
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);

        List<String> collect = sjLjjwList.stream().map(SjLjjw::getLjjh).collect(Collectors.toList());

        SjDjjc sjDjjc1 = sjDjjcMapper.selectSjDjjcByJh(sjFdsgcs.getJh());
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> sgmbySggyList=new ArrayList<>();
        if(sjDjjc1.getFaid()!=null){
            sgmbySggyList = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getZbid().toString().equals(sjDjjc1.getFaid().toString())).collect(Collectors.toList());
        }
        //获取所有井的造斜规律数据
        List<Jskd> jskdList = new ArrayList<>();
        List<DjZqsjfx> djZqsjfxList=new ArrayList<>();
        ///如果邻井不为空，则进行造斜率的数据封装
        if (sjLjjwList.size() > 0) {
            Object djdcinfo;
            CommonParam commonParam = new CommonParam();
            String[] jhs=new String[sjLjjwList.size()];
            for (int i = 0; i < sjLjjwList.size(); i++) {
                jhs[i]=sjLjjwList.get(i).getLjjh();
            }
            commonParam.setJhs(jhs);
            commonParam.setFw(sjJygjGdsjgdcsList.get(0).getFw());
           djZqsjfxList = djdcInfoMapper.getjskd(commonParam);
        }



        double previousDepth= 0;
        double csaa= 0;
        for (int i = 0; i < sjJsjgList.size(); i++) {
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if (i == 0) {
                previousDepth = 0;
            } else {
                //上一次的垂深
                previousDepth = csaa;
            }
            String gjyh="";
            /////查询符合开次的测斜数据
            if(djZqsjfxList.size()>0){
                List<Jskd> jskdList_kc =new ArrayList<>();
                double ksjs=0.0;
                if (i==0){
                    //开始井深
                    ksjs=0;
                }else {
                    ksjs= sjJsjgList.get(i).getJs();
                }
                double jsjs=sjJsjg1.getJs();
                CommonParam commonParam = new CommonParam();

                String[] jhs= djZqsjfxList.stream().map(djZqsjfx -> djZqsjfx.getJh()).toArray(String[]::new) ;
                commonParam.setJhs(jhs);
                commonParam.setKsjs(ksjs);
                commonParam.setJsjs(jsjs);
                jskdList_kc=djdcInfoMapper.getJskdList2(commonParam);
                if (jskdList_kc.size()>0){
                    for (Jskd jskd : jskdList_kc) {
                        gjyh+=jskd.getGldc()+": 自然增："+jskd.getZrz()+", 自然减："+jskd.getZrj()+", 人工增："+jskd.getRgz()+", 人工减："+jskd.getRgj()+"<br>";
                    }
                }

            }

            String kc = sjJsjg1.getKc();
            sjFdsgcs.setKc(kc);
            SjFdsgcs sjFdsgcs1 =sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);

            SgfambKcSggy sgfambKcSggy=sgmbySggyList.stream().filter(kcSggy -> kcSggy.getKc().equals(kc)).findFirst().orElse(null);
            String zyfx="";
            if(sgfambKcSggy!=null){
                zyfx=sgfambKcSggy.getFxts();
            }
            zyfx=zyfx+"<p>邻井风险<p>";
            List<String> fzqk=new ArrayList<>();
            //查询一趟钻率

            List<SjQkztfx> collect2 = sjQkztfxes.stream().filter(it -> StringUtils.isNotEmpty(it.getKc())).collect(Collectors.toList());
            List<SjQkztfx> collect1 = collect2.stream().filter(it -> it.getKc().equals(kc + "")).collect(Collectors.toList());
            SjQkztfx sjQkztfx1 = collect1.stream().max(Comparator.comparing(SjQkztfx::getYtzl)).get();
            Double ytzl=0.0;
            if(sjQkztfx1!=null){
                ytzl=sjQkztfx1.getYtzl();
            }

            if(sjFdsgcs1==null){

                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    if(jsqaList.size()>0){
                        List<String> collect3 = jsqaList.stream().map(Jsqa::getFzqk).distinct().collect(Collectors.toList());
                        //复杂情况
                        for(String s : collect3){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(s)).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zjgccs)){
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    zjycs=zjycs+"；"+s+"：钻井液措施："+clFxsb1.getZjycs();
                                }else {
                                    zjycs=zjycs+"：钻井液措施："+clFxsb1.getZjycs();
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                }
                            }

                        }
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zyfx)){
                                    zyfx=zyfx+"；<br>"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }else {
                                    zyfx=""+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }
                            }
                        }
//                        sjFdsgcs.setZjgccs(zjgccs);
//                        sjFdsgcs.setZjycs(zjycs);
                        if (zyfx.endsWith("<p>邻井风险<p>")){
                            zyfx=zyfx.replace("<p>邻井风险<p>","");
                        }
                        sjFdsgcs.setZyfx(zyfx);
                        String join = "";
                        if(fzqk.size()>0){
                            join = String.join(";", fzqk);
                        }else {
                            join = "无";
                        }

                        if(ytzl>0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%；";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk(join);
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成；";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk(join);
                        }

                    }else {
                        if(ytzl>0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk("无");
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk("无");
                        }


                    }
                }
                //井段情况
                double cs = CxszhUtil.getCs(sjJygjGdsjgdcsList, sjJsjg1.getJs());
                csaa=cs;
                SjFdsgcsDcyx sjFdsgcsDcyx  =new SjFdsgcsDcyx();

                sjFdsgcsDcyx.setJh(sjFdsgcs.getJh());
                sjFdsgcsDcyx.setKscs(previousDepth);
                sjFdsgcsDcyx.setJscs(cs);
                List<SjFdsgcsDcyx> sjFdsgcsDcyxList=sjFdsgcsDcyxMapper.getListByJh(sjFdsgcsDcyx);
                if(sjFdsgcsDcyxList.size()>0){
                    if(sjFdsgcsDcyxList.size()==1){
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc());
                    }else {
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc()+"-"+sjFdsgcsDcyxList.get(sjFdsgcsDcyxList.size()-1).getDcmc());
                    }
                }
                sjFdsgcs.setGjfx(gjyh);
                sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
            }else {
                sjFdsgcs1.setGjfx(gjyh);
                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    String fxgkcs="";
                    if(jsqaList.size()>0){
//                        List<String> fzqk=new ArrayList<>();
                        List<String> collect3 = jsqaList.stream().map(Jsqa::getFzqk).distinct().collect(Collectors.toList());
                        //复杂情况
                        for(String s : collect3){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(s)).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zjgccs)){
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    zjycs=zjycs+"；"+s+"：钻井液措施："+clFxsb1.getZjycs();
                                    fxgkcs=fxgkcs+"；"+s+"："+clFxsb1.getJkcs()+"<p>";
                                }else {
                                    zjycs=zjycs+"：钻井液措施："+clFxsb1.getZjycs();
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    fxgkcs=fxgkcs+"；"+s+"："+clFxsb1.getJkcs()+"<p>";
                                }
                            }
                        }
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zyfx)){
                                    zyfx=zyfx+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"<br>";
                                }else {
                                    zyfx="邻井存在风险："+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }
                            }
                        }
//                        sjFdsgcs1.setZjgccs(zjgccs);
//                        sjFdsgcs1.setZjycs(zjycs);
                        sjFdsgcs1.setFxgkcs(fxgkcs);
                        sjFdsgcs1.setZyfx(zyfx);
                        String join = "";
                        if(fzqk.size()>0){
                            join = String.join(";", fzqk);
                        }else {
                            join = "无";
                        }
                        if(ytzl>=0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%；";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk(join);
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成；";
                            sjFdsgcs1.setLjfzqk(join);
                            sjFdsgcs1.setTzqk(tzqk);
                        }
                    }else {
                        if(ytzl>=0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk("无");
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk("无");
                        }
                    }
                }else {
                    if(ytzl>=0&& ytzl<100){
                        String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                        sjFdsgcs1.setTzqk(tzqk);
                        sjFdsgcs1.setLjfzqk("无");
                    }else if(ytzl>=100){
                        String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                        sjFdsgcs1.setTzqk(tzqk);
                        sjFdsgcs1.setLjfzqk("无");
                    }
                }

                //井段情况
                double cs = CxszhUtil.getCs(sjJygjGdsjgdcsList, sjJsjg1.getJs());
                csaa=cs;
                SjFdsgcsDcyx sjFdsgcsDcyx  =new SjFdsgcsDcyx();

                sjFdsgcsDcyx.setJh(sjFdsgcs1.getJh());
                sjFdsgcsDcyx.setKscs(previousDepth);
                sjFdsgcsDcyx.setJscs(cs);
                List<SjFdsgcsDcyx> sjFdsgcsDcyxList=sjFdsgcsDcyxMapper.getListByJh(sjFdsgcsDcyx);
                if(sjFdsgcsDcyxList.size()>0){
                    if(sjFdsgcsDcyxList.size()==1){
                        sjFdsgcs1.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc());
                    }else {
                        sjFdsgcs1.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc()+"-"+sjFdsgcsDcyxList.get(sjFdsgcsDcyxList.size()-1).getDcmc());
                    }
                }
                sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
            }

        }

        SjZysx sjZysx = sjZysxMapper.selectSjZysxByJh(sjFdsgcs.getJh(),"喷漏卡塌");
        //查询复杂邻井
        SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcByJh(sjFdsgcs.getJh());
        CommonParam param =new CommonParam();
        param.setJkhzb(sjDjjc.getJkhzb());
        param.setJkzzb(sjDjjc.getJkzzb());
        param.setJl(3000.0);
        // 获取当前日期
        LocalDate currentDate = LocalDate.now();

        // 获取四年前的日期
        LocalDate fourYearsAgo = currentDate.minusYears(4);

        // 定义格式化器
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

        // 格式化日期
        String formattedDate = fourYearsAgo.format(formatter);
        param.setWjsjks(formattedDate);
        param.setWjsjjs(DateUtils.parseDateToStr("yyyy", new Date()));
        List<Ljjw> ljjwList=djdcService.getLjjwList2(param);
        List<String> ljjhlist = ljjwList.stream().limit(20).map(Ljjw::getJh).collect(Collectors.toList());
        collect.addAll(ljjhlist);


        if(sjZysx!=null){
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){
                        String cw ="";
                        if(StringUtils.isNotEmpty(item.getCw())){
                            cw="在"+item.getCw()+"，";
                        }
                        String sjhd="";
                        if(StringUtils.isNotEmpty(item.getSjhd())){
                            sjhd="层厚"+item.getSjhd()+"m，";
                        }
                        if(StringUtils.isNotEmpty(zyfx)){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        if(!zyfx.contains(item.getFzqk())){
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb.getFxms();
//                                        }
//                                    }else {
//                                        zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }else {
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb.getFxms();
//                                    }else {
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }
                    }
                }
                sjZysx.setZysx(zyfx);
            }
            sjZysxMapper.updateSjZysx(sjZysx);
        }else {
            sjZysx=new SjZysx();
            sjZysx.setJh(sjFdsgcs.getJh());
            sjZysx.setLb("喷漏卡塌");
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){

                        String cw ="";
                        if(StringUtils.isNotEmpty(item.getCw())){
                            cw="在"+item.getCw()+"，";
                        }
                        String sjhd="";
                        if(StringUtils.isNotEmpty(item.getSjhd())){
                            sjhd="层厚"+item.getSjhd()+"m，";
                        }

                        if(StringUtils.isNotEmpty(zyfx)){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        if(!zyfx.contains(item.getFzqk())){
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb.getFxms();
//                                        }else {
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                        }
//                                    }else {
//                                        zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }
//
//                            }
                        }else {
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb.getFxms();
//                                    }else {
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }
                    }

                }
                sjZysx.setZysx(zyfx);
            }
            sjZysxMapper.insertSjZysx(sjZysx);
        }

    }
}
