package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SgfambTjpzMapper;
import com.zjsgfa.project.zjsgfa.domain.SgfambTjpz;
import com.zjsgfa.project.zjsgfa.service.ISgfambTjpzService;

/**
 * 施工方案模板-条件配置Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-25
 */
@Service
public class SgfambTjpzServiceImpl implements ISgfambTjpzService 
{
    @Autowired
    private SgfambTjpzMapper sgfambTjpzMapper;

    /**
     * 查询施工方案模板-条件配置
     * 
     * @param id 施工方案模板-条件配置主键
     * @return 施工方案模板-条件配置
     */
    @Override
    public SgfambTjpz selectSgfambTjpzById(Long id)
    {
        return sgfambTjpzMapper.selectSgfambTjpzById(id);
    }

    /**
     * 查询施工方案模板-条件配置列表
     * 
     * @param sgfambTjpz 施工方案模板-条件配置
     * @return 施工方案模板-条件配置
     */
    @Override
    public List<SgfambTjpz> selectSgfambTjpzList(SgfambTjpz sgfambTjpz)
    {
        return sgfambTjpzMapper.selectSgfambTjpzList(sgfambTjpz);
    }

    /**
     * 新增施工方案模板-条件配置
     * 
     * @param sgfambTjpz 施工方案模板-条件配置
     * @return 结果
     */
    @Override
    public int insertSgfambTjpz(SgfambTjpz sgfambTjpz)
    {
        return sgfambTjpzMapper.insertSgfambTjpz(sgfambTjpz);
    }

    /**
     * 修改施工方案模板-条件配置
     * 
     * @param sgfambTjpz 施工方案模板-条件配置
     * @return 结果
     */
    @Override
    public int updateSgfambTjpz(SgfambTjpz sgfambTjpz)
    {
        sgfambTjpz.setUpdateTime(DateUtils.getNowDate());
        return sgfambTjpzMapper.updateSgfambTjpz(sgfambTjpz);
    }

    /**
     * 批量删除施工方案模板-条件配置
     * 
     * @param ids 需要删除的施工方案模板-条件配置主键
     * @return 结果
     */
    @Override
    public int deleteSgfambTjpzByIds(Long[] ids)
    {
        return sgfambTjpzMapper.deleteSgfambTjpzByIds(ids);
    }

    /**
     * 删除施工方案模板-条件配置信息
     * 
     * @param id 施工方案模板-条件配置主键
     * @return 结果
     */
    @Override
    public int deleteSgfambTjpzById(Long id)
    {
        return sgfambTjpzMapper.deleteSgfambTjpzById(id);
    }
}
