package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.JcxxTsgj;
import com.zjsgfa.project.zjsgfa.service.IJcxxTsgjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 基础信息_特殊工具Controller
 * 
 * @author
 * @date 2025-08-06
 */
@RestController
@RequestMapping("/system/jcxxTsgj")
public class JcxxTsgjController extends BaseController
{
    @Autowired
    private IJcxxTsgjService jcxxTsgjService;

    /**
     * 查询基础信息_特殊工具列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:list')")
    @GetMapping("/list")
    public TableDataInfo list(JcxxTsgj jcxxTsgj)
    {
//        startPage();
        List<JcxxTsgj> list = jcxxTsgjService.selectJcxxTsgjList(jcxxTsgj);
        return getDataTable(list);
    }

    /**
     * 导出基础信息_特殊工具列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:export')")
    @Log(title = "基础信息_特殊工具", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JcxxTsgj jcxxTsgj)
    {
        List<JcxxTsgj> list = jcxxTsgjService.selectJcxxTsgjList(jcxxTsgj);
        ExcelUtil<JcxxTsgj> util = new ExcelUtil<JcxxTsgj>(JcxxTsgj.class);
        util.exportExcel(response, list, "基础信息_特殊工具数据");
    }

    /**
     * 获取基础信息_特殊工具详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jcxxTsgjService.selectJcxxTsgjById(id));
    }

    /**
     * 新增基础信息_特殊工具
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:add')")
    @Log(title = "基础信息_特殊工具", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JcxxTsgj jcxxTsgj)
    {
        return toAjax(jcxxTsgjService.insertJcxxTsgj(jcxxTsgj));
    }

    /**
     * 修改基础信息_特殊工具
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:edit')")
    @Log(title = "基础信息_特殊工具", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JcxxTsgj jcxxTsgj)
    {
        return toAjax(jcxxTsgjService.updateJcxxTsgj(jcxxTsgj));
    }

    /**
     * 删除基础信息_特殊工具
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxTsgj:remove')")
    @Log(title = "基础信息_特殊工具", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(jcxxTsgjService.deleteJcxxTsgjByIds(ids));
    }
}
