package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.zjsgfa.project.zjsgfa.domain.JcxxTsgj;
import com.zjsgfa.project.zjsgfa.domain.SjFl;
import com.zjsgfa.project.zjsgfa.mapper.JcxxTsgjMapper;
import com.zjsgfa.project.zjsgfa.mapper.SjFlMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdsgcsTsgjMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsTsgj;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsTsgjService;

/**
 * 设计-分段施工措施_特殊工具Service业务层处理
 * 
 * @author
 * @date 2025-08-06
 */
@Service
public class SjFdsgcsTsgjServiceImpl implements ISjFdsgcsTsgjService 
{
    @Autowired
    private SjFdsgcsTsgjMapper sjFdsgcsTsgjMapper;

    @Autowired
    private JcxxTsgjMapper jcxxTsgjMapper;

    @Autowired
    private SjFlMapper sjFlMapper;

    /**
     * 查询设计-分段施工措施_特殊工具
     * 
     * @param id 设计-分段施工措施_特殊工具主键
     * @return 设计-分段施工措施_特殊工具
     */
    @Override
    public SjFdsgcsTsgj selectSjFdsgcsTsgjById(Long id)
    {
        return sjFdsgcsTsgjMapper.selectSjFdsgcsTsgjById(id);
    }

    /**
     * 查询设计-分段施工措施_特殊工具列表
     * 
     * @param sjFdsgcsTsgj 设计-分段施工措施_特殊工具
     * @return 设计-分段施工措施_特殊工具
     */
    @Override
    public List<SjFdsgcsTsgj> selectSjFdsgcsTsgjList(SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        return sjFdsgcsTsgjMapper.selectSjFdsgcsTsgjList(sjFdsgcsTsgj);
    }

    /**
     * 新增设计-分段施工措施_特殊工具
     * 
     * @param sjFdsgcsTsgj 设计-分段施工措施_特殊工具
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsTsgj(SjFdsgcsTsgj sjFdsgcsTsgj)
    {


        int i = sjFdsgcsTsgjMapper.insertSjFdsgcsTsgj(sjFdsgcsTsgj);

        SjFdsgcsTsgj sjFdsgcsTsgj1 =new SjFdsgcsTsgj();
        sjFdsgcsTsgj1.setJh(sjFdsgcsTsgj.getJh());
        List<SjFdsgcsTsgj> sjFdsgcsTsgjs = selectSjFdsgcsTsgjList(sjFdsgcsTsgj1);
        List<String> collect = sjFdsgcsTsgjs.stream().map(SjFdsgcsTsgj::getGjmc).distinct().collect(Collectors.toList());
        JcxxTsgj jcxxTsgj =new JcxxTsgj();
        jcxxTsgj.setGjmcs(collect);
        List<JcxxTsgj> jcxxTsgjs = jcxxTsgjMapper.selectJcxxTsgjList(jcxxTsgj);
        if(jcxxTsgjs.size()>0){

            SjFl sjFl=new SjFl();
            sjFl.setJh(sjFdsgcsTsgj.getJh());
            List<SjFl> sjFls = sjFlMapper.selectSjFlList(sjFl);
            if(sjFls.size()>0){
                SjFl sjFl1 = sjFls.get(0);
                List<String> collect1 = jcxxTsgjs.stream().map(JcxxTsgj::getSyzn).distinct().collect(Collectors.toList());
                String syzn=String.join( ",",collect1);
                sjFl1.setJh(sjFdsgcsTsgj.getJh());
                sjFl1.setSyzn(syzn);
                sjFlMapper.updateSjFl(sjFl1);

            }else {
                List<String> collect1 = jcxxTsgjs.stream().map(JcxxTsgj::getSyzn).distinct().collect(Collectors.toList());
                String syzn=String.join( ",",collect1);
                SjFl sjFl1=new SjFl();
                sjFl1.setJh(sjFdsgcsTsgj.getJh());
                sjFl1.setSyzn(syzn);
                sjFlMapper.insertSjFl(sjFl1);
            }
        }

        return i;
    }

    /**
     * 修改设计-分段施工措施_特殊工具
     * 
     * @param sjFdsgcsTsgj 设计-分段施工措施_特殊工具
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsTsgj(SjFdsgcsTsgj sjFdsgcsTsgj)
    {
        int i = sjFdsgcsTsgjMapper.updateSjFdsgcsTsgj(sjFdsgcsTsgj);
        SjFdsgcsTsgj sjFdsgcsTsgj1 =new SjFdsgcsTsgj();
        sjFdsgcsTsgj1.setJh(sjFdsgcsTsgj.getJh());
        List<SjFdsgcsTsgj> sjFdsgcsTsgjs = selectSjFdsgcsTsgjList(sjFdsgcsTsgj1);
        List<String> collect = sjFdsgcsTsgjs.stream().map(SjFdsgcsTsgj::getGjmc).distinct().collect(Collectors.toList());
        JcxxTsgj jcxxTsgj =new JcxxTsgj();
        jcxxTsgj.setGjmcs(collect);
        List<JcxxTsgj> jcxxTsgjs = jcxxTsgjMapper.selectJcxxTsgjList(jcxxTsgj);
        if(jcxxTsgjs.size()>0){

            SjFl sjFl=new SjFl();
            sjFl.setJh(sjFdsgcsTsgj.getJh());
            List<SjFl> sjFls = sjFlMapper.selectSjFlList(sjFl);
            if(sjFls.size()>0){
                SjFl sjFl1 = sjFls.get(0);
                List<String> collect1 = jcxxTsgjs.stream().map(JcxxTsgj::getSyzn).distinct().collect(Collectors.toList());
                String syzn=String.join( ",",collect1);
                sjFl1.setJh(sjFdsgcsTsgj.getJh());
                sjFl1.setSyzn(syzn);
                sjFlMapper.updateSjFl(sjFl1);

            }else {
                List<String> collect1 = jcxxTsgjs.stream().map(JcxxTsgj::getSyzn).distinct().collect(Collectors.toList());
                String syzn=String.join( ",",collect1);
                SjFl sjFl1=new SjFl();
                sjFl1.setJh(sjFdsgcsTsgj.getJh());
                sjFl1.setSyzn(syzn);
                sjFlMapper.insertSjFl(sjFl1);
            }
        }

        return i;
    }

    /**
     * 批量删除设计-分段施工措施_特殊工具
     * 
     * @param ids 需要删除的设计-分段施工措施_特殊工具主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsTsgjByIds(Long[] ids)
    {
        return sjFdsgcsTsgjMapper.deleteSjFdsgcsTsgjByIds(ids);
    }

    /**
     * 删除设计-分段施工措施_特殊工具信息
     * 
     * @param id 设计-分段施工措施_特殊工具主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsTsgjById(Long id)
    {
        return sjFdsgcsTsgjMapper.deleteSjFdsgcsTsgjById(id);
    }
}
