package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.project.zjsgfa.domain.*;
import com.zjsgfa.project.zjsgfa.mapper.*;
import com.zjsgfa.project.zjsgfa.util.CxszhUtil;
import com.zjsgfa.project.zt.domain.Jsqa;
import com.zjsgfa.project.zt.mapper.JsqaMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsService;

/**
 * 设计-分段施工措施Service业务层处理
 * 
 * @author
 * @date 2025-08-06
 */
@Service
public class SjFdsgcsServiceImpl implements ISjFdsgcsService 
{
    @Autowired
    private SjFdsgcsMapper sjFdsgcsMapper;

    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjFdsgcsDcyxMapper sjFdsgcsDcyxMapper;

    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;

    @Autowired
    private JsqaMapper jsqaMapper;

    @Autowired
    private ClFxsbMapper clFxsbMapper;

    @Autowired
    private SjZysxMapper sjZysxMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;


    /**
     * 查询设计-分段施工措施
     * 
     * @param id 设计-分段施工措施主键
     * @return 设计-分段施工措施
     */
    @Override
    public SjFdsgcs selectSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.selectSjFdsgcsById(id);
    }

    /**
     * 查询设计-分段施工措施列表
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 设计-分段施工措施
     */
    @Override
    public List<SjFdsgcs> selectSjFdsgcsList(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.selectSjFdsgcsList(sjFdsgcs);
    }

    /**
     * 新增设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int insertSjFdsgcs(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
    }

    /**
     * 修改设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int updateSjFdsgcs(SjFdsgcs sjFdsgcs)
    {

        if(StringUtils.isNotEmpty(sjFdsgcs.getGjfx())){
            String s = new String(Base64.decode(sjFdsgcs.getGjfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjfx(s);
        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getGjyh())){
            String s = new String(Base64.decode(sjFdsgcs.getGjyh()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjyh(s);
        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getDcyl())){
            String s = new String(Base64.decode(sjFdsgcs.getDcyl()), StandardCharsets.UTF_8);
            sjFdsgcs.setDcyl(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZyfx())){
            String s = new String(Base64.decode(sjFdsgcs.getZyfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZyfx(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getFxgkcs())){
            String s = new String(Base64.decode(sjFdsgcs.getFxgkcs()), StandardCharsets.UTF_8);
            sjFdsgcs.setFxgkcs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjycs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjycs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjycs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjgccs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjgccs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjgccs(s);
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzh())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzh()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzh(s);
            //
            SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
            sjSggyZjzhcs.setJh(sjFdsgcs.getJh());
            sjSggyZjzhcs.setKc(sjFdsgcs.getKc());
            SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
            if(sjSggyZjzhcs1!=null){
                sjSggyZjzhcs1.setZjjg(s);
                sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
            }
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzhzysx())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzhzysx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzhzysx(s);
        }
        return sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
    }

    /**
     * 批量删除设计-分段施工措施
     * 
     * @param ids 需要删除的设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsByIds(Long[] ids)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsByIds(ids);
    }

    /**
     * 删除设计-分段施工措施信息
     * 
     * @param id 设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsById(id);
    }

    @Override
    public void jsfdsgcs(SjFdsgcs sjFdsgcs) {
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(sjFdsgcs.getJh());
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        SjLjjw sjLjjw =new SjLjjw();
        sjLjjw.setJh(sjFdsgcs.getJh());
        List<SjLjjw> sjLjjwList = sjLjjwMapper.selectSjLjjwList(sjLjjw);

        List<ClFxsb> clFxsbList = clFxsbMapper.selectClFxsbList(new ClFxsb());

        SjJygjGdsjgdcs sjJygjGdsjgdcs=new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(sjFdsgcs.getJh());
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);

        List<String> collect = sjLjjwList.stream().map(SjLjjw::getLjjh).collect(Collectors.toList());
        double previousDepth= 0;
        double csaa= 0;
        for (int i = 0; i < sjJsjgList.size(); i++) {
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if (i == 0) {
                previousDepth = 0;
            } else {
                //上一次的垂深
                previousDepth = csaa;
            }
            String kc = sjJsjg1.getKc();
            sjFdsgcs.setKc(kc);
            SjFdsgcs sjFdsgcs1 =sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
            if(sjFdsgcs1==null){
                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    String zyfx="";
                    if(jsqaList.size()>0){
                        List<String> fzqk=new ArrayList<>();
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            if(StringUtils.isNotEmpty(zjycs)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zjycs.contains(item.getFzqk())){
                                                zjycs=zjycs+"；"+item.getFzqk()+"：钻井液措施："+clFxsb.getZjycs();
                                            }
                                        }
                                    }

                                }
                            }else {
                               for(ClFxsb clFxsb :clFxsbList){
                                   if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                       if(clFxsb.getPdtj().contains(item.getFzqk())){
                                           zjycs=item.getFzqk()+"：钻井液措施："+clFxsb.getZjycs();
                                       }
                                   }

                               }
//
                            }

                            if(StringUtils.isNotEmpty(zjgccs)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zjgccs.contains(item.getFzqk())){
                                                zjgccs=zjgccs+"；"+item.getFzqk()+"：钻井工程措施："+clFxsb.getGcjscs();
                                            }
                                        }
                                    }

                                }
                            }else {
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            zjgccs=item.getFzqk()+"：钻井工程措施："+clFxsb.getGcjscs();
                                        }
                                    }

                                }
                            }
                            if(StringUtils.isNotEmpty(zyfx)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zyfx.contains(item.getFzqk())){
                                                zyfx=zyfx+"；邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                            }
                                        }
                                    }

                                }
                            }else {
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            zyfx="邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                        }
                                    }

                                }
                            }
                        }
                        sjFdsgcs.setZjgccs(zjgccs);
                        sjFdsgcs.setZjycs(zjycs);
                        sjFdsgcs.setZyfx(zyfx);
                        sjFdsgcs.setTzqk(String.join(";",fzqk));
                    }else {
                        sjFdsgcs.setTzqk("结合邻井"+kc+"无复杂数据，可实现一趟钻完成");
                    }
                }else {
                    sjFdsgcs.setTzqk("结合邻井"+kc+"无复杂数据，可实现一趟钻完成");
                }
                //井段情况
                double cs = CxszhUtil.getCs(sjJygjGdsjgdcsList, sjJsjg1.getJs());
                csaa=cs;
                SjFdsgcsDcyx sjFdsgcsDcyx  =new SjFdsgcsDcyx();

                sjFdsgcsDcyx.setJh(sjFdsgcs.getJh());
                sjFdsgcsDcyx.setKscs(previousDepth);
                sjFdsgcsDcyx.setJscs(cs);
                List<SjFdsgcsDcyx> sjFdsgcsDcyxList=sjFdsgcsDcyxMapper.getListByJh(sjFdsgcsDcyx);
                if(sjFdsgcsDcyxList.size()>0){
                    if(sjFdsgcsDcyxList.size()==1){
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc());
                    }else {
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc()+"-"+sjFdsgcsDcyxList.get(sjFdsgcsDcyxList.size()-1).getDcmc());
                    }
                }
                sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
            }else {
                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    String zyfx="";
                    if(jsqaList.size()>0){
                        List<String> fzqk=new ArrayList<>();
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            if(StringUtils.isNotEmpty(zjycs)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zjycs.contains(item.getFzqk())){
                                                zjycs=zjycs+"；"+item.getFzqk()+"：钻井液措施："+clFxsb.getZjycs();
                                            }
                                        }
                                    }

                                }
                            }else {
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            zjycs=item.getFzqk()+"：钻井液措施："+clFxsb.getZjycs();
                                        }
                                    }

                                }
//
                            }

                            if(StringUtils.isNotEmpty(zjgccs)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zjgccs.contains(item.getFzqk())){
                                                zjgccs=zjgccs+"；"+item.getFzqk()+"：钻井工程措施："+clFxsb.getGcjscs();
                                            }
                                        }
                                    }

                                }
                            }else {
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            zjgccs=item.getFzqk()+"：钻井工程措施："+clFxsb.getGcjscs();
                                        }
                                    }

                                }
                            }
                            if(StringUtils.isNotEmpty(zyfx)){
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            if(!zyfx.contains(item.getFzqk())){
                                                zyfx=zyfx+"；邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                            }
                                        }
                                    }

                                }
                            }else {
                                for(ClFxsb clFxsb :clFxsbList){
                                    if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                        if(clFxsb.getPdtj().contains(item.getFzqk())){
                                            zyfx="邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                        }
                                    }

                                }
                            }
                        }
                        sjFdsgcs1.setZjgccs(zjgccs);
                        sjFdsgcs1.setZjycs(zjycs);
                        sjFdsgcs1.setZyfx(zyfx);
                        sjFdsgcs1.setTzqk(String.join(";",fzqk));
                    }else {
                        sjFdsgcs1.setTzqk("结合邻井"+kc+"无复杂数据，可实现一趟钻完成");
                    }
                }else {
                    sjFdsgcs1.setTzqk("结合邻井"+kc+"无复杂数据，可实现一趟钻完成");
                }
                sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
            }

        }

        SjZysx sjZysx = sjZysxMapper.selectSjZysxByJh(sjFdsgcs.getJh(),"喷漏卡塌");
        if(sjZysx!=null){
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){
                        if(StringUtils.isNotEmpty(zyfx)){
                            for(ClFxsb clFxsb :clFxsbList){
                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
                                        if(!zyfx.contains(item.getFzqk())){
                                            zyfx=zyfx+"；邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                        }
                                    }
                                }

                            }
                        }else {
                            for(ClFxsb clFxsb :clFxsbList){
                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
                                        zyfx="邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                    }
                                }

                            }
                        }
                    }
                }
                sjZysx.setZysx(zyfx);
            }
        }else {
            sjZysx=new SjZysx();
            sjZysx.setJh(sjFdsgcs.getJh());
            sjZysx.setLb("喷漏卡塌");
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){
                        if(StringUtils.isNotEmpty(zyfx)){
                            for(ClFxsb clFxsb :clFxsbList){
                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
                                        if(!zyfx.contains(item.getFzqk())){
                                            zyfx=zyfx+"；邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                        }
                                    }
                                }

                            }
                        }else {
                            for(ClFxsb clFxsb :clFxsbList){
                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
                                        zyfx="邻井"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"，风险描述："+clFxsb.getFxms();
                                    }
                                }

                            }
                        }
                    }

                }
                sjZysx.setZysx(zyfx);
            }
            sjZysxMapper.insertSjZysx(sjZysx);
        }

    }
}
