package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjQkztfx;
import com.zjsgfa.project.zjsgfa.service.ISjQkztfxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-区块钻头分析Controller
 * 
 * @author
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjQkztfx")
public class SjQkztfxController extends BaseController
{
    @Autowired
    private ISjQkztfxService sjQkztfxService;

    /**
     * 查询设计-区块钻头分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjQkztfx sjQkztfx)
    {
//        startPage();
        List<SjQkztfx> list = sjQkztfxService.selectSjQkztfxList(sjQkztfx);
        return getDataTable(list);
    }

    /**
     * 导出设计-区块钻头分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:export')")
    @Log(title = "设计-区块钻头分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjQkztfx sjQkztfx)
    {
        List<SjQkztfx> list = sjQkztfxService.selectSjQkztfxList(sjQkztfx);
        ExcelUtil<SjQkztfx> util = new ExcelUtil<SjQkztfx>(SjQkztfx.class);
        util.exportExcel(response, list, "设计-区块钻头分析数据");
    }

    /**
     * 获取设计-区块钻头分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjQkztfxService.selectSjQkztfxById(id));
    }

    /**
     * 新增设计-区块钻头分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:add')")
    @Log(title = "设计-区块钻头分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjQkztfx sjQkztfx)
    {
        return toAjax(sjQkztfxService.insertSjQkztfx(sjQkztfx));
    }

    /**
     * 修改设计-区块钻头分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:edit')")
    @Log(title = "设计-区块钻头分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjQkztfx sjQkztfx)
    {
        return toAjax(sjQkztfxService.updateSjQkztfx(sjQkztfx));
    }

    /**
     * 删除设计-区块钻头分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjQkztfx:remove')")
    @Log(title = "设计-区块钻头分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjQkztfxService.deleteSjQkztfxByIds(ids));
    }
}
