package com.ruoyi.project.zt.mapper;

import java.util.List;

import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.project.zt.domain.CommonParam;
import com.ruoyi.project.zt.domain.LjSzfxjg;

/**
 * 邻井-实钻分析结果Mapper接口
 * 
 * @author ruoyi
 * @date 2025-06-29
 */
@DataSource(value = DataSourceType.MASTER)
public interface LjSzfxjgMapper 
{
    /**
     * 查询邻井-实钻分析结果
     * 
     * @param id 邻井-实钻分析结果主键
     * @return 邻井-实钻分析结果
     */
    public LjSzfxjg selectLjSzfxjgById(Long id);

    /**
     * 查询邻井-实钻分析结果列表
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 邻井-实钻分析结果集合
     */
    public List<LjSzfxjg> selectLjSzfxjgList(LjSzfxjg ljSzfxjg);

    /**
     * 新增邻井-实钻分析结果
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 结果
     */
    public int insertLjSzfxjg(LjSzfxjg ljSzfxjg);

    /**
     * 修改邻井-实钻分析结果
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 结果
     */
    public int updateLjSzfxjg(LjSzfxjg ljSzfxjg);

    /**
     * 删除邻井-实钻分析结果
     * 
     * @param id 邻井-实钻分析结果主键
     * @return 结果
     */
    public int deleteLjSzfxjgById(Long id);

    /**
     * 批量删除邻井-实钻分析结果
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteLjSzfxjgByIds(Long[] ids);

    int batchLjSzfxjg(List<LjSzfxjg> ljSzfxjgList);

    List<LjSzfxjg> getszfxjgList(CommonParam param);

}
