package com.ruoyi.project.zt.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zt.domain.LjZjzhfx;
import com.ruoyi.project.zt.service.ILjZjzhfxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 邻井-钻具组合分析Controller
 * 
 * @author ruoyi
 * @date 2025-07-02
 */
@RestController
@RequestMapping("/system/ljZjzhfx")
public class LjZjzhfxController extends BaseController
{
    @Autowired
    private ILjZjzhfxService ljZjzhfxService;

    /**
     * 查询邻井-钻具组合分析列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:list')")
    @GetMapping("/list")
    public TableDataInfo list(LjZjzhfx ljZjzhfx)
    {
        startPage();
        List<LjZjzhfx> list = ljZjzhfxService.selectLjZjzhfxList(ljZjzhfx);
        return getDataTable(list);
    }

    /**
     * 导出邻井-钻具组合分析列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:export')")
    @Log(title = "邻井-钻具组合分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LjZjzhfx ljZjzhfx)
    {
        List<LjZjzhfx> list = ljZjzhfxService.selectLjZjzhfxList(ljZjzhfx);
        ExcelUtil<LjZjzhfx> util = new ExcelUtil<LjZjzhfx>(LjZjzhfx.class);
        util.exportExcel(response, list, "邻井-钻具组合分析数据");
    }

    /**
     * 获取邻井-钻具组合分析详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ljZjzhfxService.selectLjZjzhfxById(id));
    }

    /**
     * 新增邻井-钻具组合分析
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:add')")
    @Log(title = "邻井-钻具组合分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LjZjzhfx ljZjzhfx)
    {
        return toAjax(ljZjzhfxService.insertLjZjzhfx(ljZjzhfx));
    }

    /**
     * 修改邻井-钻具组合分析
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:edit')")
    @Log(title = "邻井-钻具组合分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LjZjzhfx ljZjzhfx)
    {
        return toAjax(ljZjzhfxService.updateLjZjzhfx(ljZjzhfx));
    }

    /**
     * 删除邻井-钻具组合分析
     */
    @PreAuthorize("@ss.hasPermi('system:ljZjzhfx:remove')")
    @Log(title = "邻井-钻具组合分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ljZjzhfxService.deleteLjZjzhfxByIds(ids));
    }
}
