package com.ruoyi.project.zjsgfa.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.project.zjsgfa.domain.SjJsjgt;
import com.ruoyi.project.zjsgfa.domain.SjJygjGdsjgdcs;
import com.ruoyi.project.zjsgfa.mapper.SjJygjGdsjgdcsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjJsjgMapper;
import com.ruoyi.project.zjsgfa.domain.SjJsjg;
import com.ruoyi.project.zjsgfa.service.ISjJsjgService;

/**
 * 设计信息-井身结构Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-24
 */
@Service
public class SjJsjgServiceImpl implements ISjJsjgService 
{
    @Autowired
    private SjJsjgMapper sjJsjgMapper;

    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;



    /**
     * 查询设计信息-井身结构
     * 
     * @param id 设计信息-井身结构主键
     * @return 设计信息-井身结构
     */
    @Override
    public SjJsjg selectSjJsjgById(Long id)
    {
        return sjJsjgMapper.selectSjJsjgById(id);
    }

    /**
     * 查询设计信息-井身结构列表
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 设计信息-井身结构
     */
    @Override
    public List<SjJsjg> selectSjJsjgList(SjJsjg sjJsjg)
    {
        return sjJsjgMapper.selectSjJsjgList(sjJsjg);
    }

    /**
     * 新增设计信息-井身结构
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 结果
     */
    @Override
    public int insertSjJsjg(SjJsjg sjJsjg)
    {
        return sjJsjgMapper.insertSjJsjg(sjJsjg);
    }

    /**
     * 修改设计信息-井身结构
     * 
     * @param sjJsjg 设计信息-井身结构
     * @return 结果
     */
    @Override
    public int updateSjJsjg(SjJsjg sjJsjg)
    {
        sjJsjg.setUpdateTime(DateUtils.getNowDate());
        return sjJsjgMapper.updateSjJsjg(sjJsjg);
    }

    /**
     * 批量删除设计信息-井身结构
     * 
     * @param ids 需要删除的设计信息-井身结构主键
     * @return 结果
     */
    @Override
    public int deleteSjJsjgByIds(Long[] ids)
    {
        return sjJsjgMapper.deleteSjJsjgByIds(ids);
    }

    /**
     * 删除设计信息-井身结构信息
     * 
     * @param id 设计信息-井身结构主键
     * @return 结果
     */
    @Override
    public int deleteSjJsjgById(Long id)
    {
        return sjJsjgMapper.deleteSjJsjgById(id);
    }

    @Override
    public Map selectJsjgt(SjJsjg sjJsjg) {

        List<SjJsjg> list = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        SjJygjGdsjgdcs sjJygjGdsjgdcs =new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(sjJsjg.getJh());
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);

        Map jsJgmap =new HashMap();
        Double maxY =0.0;
        Double maxX =0.0;
        if(sjJygjGdsjgdcsList.size()>0){
            maxY = sjJygjGdsjgdcsList.stream().map(SjJygjGdsjgdcs::getCs).max(Double::compare).get();
            maxX = sjJygjGdsjgdcsList.stream().map(SjJygjGdsjgdcs::getSpy).max(Double::compare).get();
        }

        jsJgmap.put("maxY",Math.ceil(maxY+500));
        jsJgmap.put("maxX",Math.ceil(maxX+1000));

        //获取中心线
        List zxList = new ArrayList<>();
        for(int i=0;i<sjJygjGdsjgdcsList.size();i++){
            SjJygjGdsjgdcs jg=sjJygjGdsjgdcsList.get(i);
            Double cs1 = jg.getCs();
            Double spy1 = jg.getSpy();
            //填充中心线
            Map zxmap =new HashMap();

            zxmap.put("x",Math.ceil(spy1+500));
            zxmap.put("y",cs1);
            if(i==0){
                zxmap.put("y",new BigDecimal(0));
            }


            zxList.add(zxmap);
        }
        jsJgmap.put("zx",zxList);

        List kcList = new ArrayList<>();

        List wellConstructPointList = new ArrayList<>();
        List fillList = new ArrayList<>();
        for (int i=0;i<list.size();i++) {
            SjJsjg item = list.get(i);
            Double snfg = item.getSnfg();
            if (snfg == null) {
                snfg = 0.0;
            }

            //取出小于等于井身结构的输出结果
            List<SjJygjGdsjgdcs> collect = sjJygjGdsjgdcsList.stream().filter(it -> it.getJs().compareTo(item.getJs()) == -1 || it.getJs().compareTo(item.getJs()) == 0).collect(Collectors.toList());
            List constructLineList1 = new ArrayList<>();
            List constructLineList2 = new ArrayList<>();

            //开次左侧----------------------------
            Map kcmap1 = new HashMap();

            // 开次右侧----------------------------
            Map kcmap2 = new HashMap();

            // 填充左侧
            Map tcmap1 = new HashMap();
            List wellConstructFill1 = new ArrayList<>();

            Map tcmap2 = new HashMap();
            List wellConstructFill2 = new ArrayList<>();

            for (int k = 0; k < collect.size(); k++) {
                SjJygjGdsjgdcs jg = collect.get(k);
                double cs1 = jg.getCs();
                double spy1 = jg.getSpy();

                //左侧
                Map kczbqdmap1 = new HashMap();
                Double x = Math.ceil(spy1 + 500);
                Double y = cs1;
                Double xa = x - item.getZtzj();
//                BigDecimal ya = x.subtract(item.getJxcc());
                kczbqdmap1.put("x", xa);
                kczbqdmap1.put("y", y);
                if (k == 0) {
                    kczbqdmap1.put("y", 0);
                }

                constructLineList1.add(kczbqdmap1);

                //右侧
                Map kczbqdmap2 = new HashMap();//起点
                Double xa2 = x + item.getZtzj();
                kczbqdmap2.put("x", xa2);
                kczbqdmap2.put("y", y);
                if (k == 0) {
                    kczbqdmap2.put("y", 0);
                }
                constructLineList2.add(kczbqdmap2);

                //上个开次 的井眼尺寸  用于填充
                double jyccS = 0;
                if (i > 0) {
                    SjJsjg jgxx1 = list.get(i - 1);
                    if (jgxx1.getZtzj() != null) {
                        jyccS = jgxx1.getZtzj() - item.getZtzj();
                    }
                } else {
                    jyccS = item.getZtzj();  // 一开没有上一次
                }

                //填充左侧
                //第一次固定减50 填充
                Map tczbqdmap1 = new HashMap();
                //起始y=水泥返高
                //起始x
                if (jg.getCs().doubleValue() >= snfg.doubleValue()) {
                    if (i == 0) {
                        tczbqdmap1.put("x", Math.round(xa - 100));
                        tczbqdmap1.put("y", y);
                        if (k == 0) {
                            tczbqdmap1.put("y", snfg);
                            tczbqdmap1.put("x1", xa);
                            tczbqdmap1.put("y1", snfg);
                        } else {
                            tczbqdmap1.put("x1", xa);
                            tczbqdmap1.put("y1", y);
                        }
                    } else {
                        tczbqdmap1.put("x", Math.round(xa - jyccS));
                        tczbqdmap1.put("y", y);
                        tczbqdmap1.put("x1", xa);
                        tczbqdmap1.put("y1", y);
                    }
                    wellConstructFill1.add(tczbqdmap1);
                }

                //填充右侧
                //第一次固定加50 填充

                Map tczbqdmap2 =new HashMap();
                //起始y=水泥返高
                //起始x
                if(jg.getCs().doubleValue()>=snfg.doubleValue()){
                    if(i==0){
                        tczbqdmap2.put("x",xa2+100);
                        tczbqdmap2.put("y",y);
                        if(k==0){
                            tczbqdmap2.put("y",snfg);
                            tczbqdmap2.put("x1",xa2);
                            tczbqdmap2.put("y1",snfg);
                        }else {
                            tczbqdmap2.put("x1",xa2);
                            tczbqdmap2.put("y1",y);
                        }
                    }else {
                        tczbqdmap2.put("x",xa2+jyccS);
                        tczbqdmap2.put("y",y);
                        tczbqdmap2.put("x1",xa2);
                        tczbqdmap2.put("y1",y);
                    }
                    wellConstructFill2.add(tczbqdmap2);
                }

            }



            kcmap1.put("constructLine",constructLineList1);
            kcList.add(kcmap1);
            kcmap2.put("constructLine",constructLineList2);
            kcList.add(kcmap2);



            tcmap1.put("wellConstructFill",wellConstructFill1);
            fillList.add(tcmap1);
            //填充右侧
            tcmap2.put("wellConstructFill",wellConstructFill2);
            fillList.add(tcmap2);


//            //填充描述
            Map msmap =new HashMap();
            List point = new ArrayList<>();
            if(collect.size()>0){
                int index=0;
                if(collect.size()%2==0){
                    index=collect.size()/2-1;
                }else {
                    index=collect.size()/2;
                }
                SjJygjGdsjgdcs dtJygjJg1 = collect.get(index);
                Double  x= dtJygjJg1.getSpy()+500;
                Double  y= dtJygjJg1.getCs();
                Double xa2 = x+item.getZtzj();
                double[] msqd = {xa2.doubleValue(),y.doubleValue()};//起点
                double[] mszd ={xa2.doubleValue()+900,y.doubleValue()};//终点
                point.add(msqd);
                point.add(mszd);
            }
            msmap.put("point",point);
            msmap.put("describe1","φ"+item.getZtzj()+"mm   *   "+item.getJs()+"m");
            msmap.put("describe2","φ"+item.getTtwj()+"mm   *   "+item.getTtxs()+"m");
            wellConstructPointList.add(msmap);
        }

        jsJgmap.put("kc",kcList);
        jsJgmap.put("fill",fillList);
        jsJgmap.put("wellConstructPoint",wellConstructPointList);

        Map map =new HashMap();
        map.put("code",200);
        map.put("msg","成功");
        map.put("jsJgmap",jsJgmap);

        return map;
    }

    @Override
    public int savaJsjgt(SjJsjgt sjJsjgt) {
        sjJsjgMapper.deleteSjJsjgtById(sjJsjgt.getZbid());
        return sjJsjgMapper.insertSjJsjgt(sjJsjgt);
    }
}
