package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjZysx;
import com.ruoyi.project.zjsgfa.service.ISjZysxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-注意事项Controller
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjZysx")
public class SjZysxController extends BaseController
{
    @Autowired
    private ISjZysxService sjZysxService;

    /**
     * 查询设计信息-注意事项列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZysx sjZysx)
    {
        startPage();
        List<SjZysx> list = sjZysxService.selectSjZysxList(sjZysx);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-注意事项列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:export')")
    @Log(title = "设计信息-注意事项", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZysx sjZysx)
    {
        List<SjZysx> list = sjZysxService.selectSjZysxList(sjZysx);
        ExcelUtil<SjZysx> util = new ExcelUtil<SjZysx>(SjZysx.class);
        util.exportExcel(response, list, "设计信息-注意事项数据");
    }

    /**
     * 获取设计信息-注意事项详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZysxService.selectSjZysxById(id));
    }

    /**
     * 新增设计信息-注意事项
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:add')")
    @Log(title = "设计信息-注意事项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZysx sjZysx)
    {
        return toAjax(sjZysxService.insertSjZysx(sjZysx));
    }

    /**
     * 修改设计信息-注意事项
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:edit')")
    @Log(title = "设计信息-注意事项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZysx sjZysx)
    {
        return toAjax(sjZysxService.updateSjZysx(sjZysx));
    }

    /**
     * 删除设计信息-注意事项
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZysx:remove')")
    @Log(title = "设计信息-注意事项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZysxService.deleteSjZysxByIds(ids));
    }
}
