package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.MxfxjgbMapper;
import com.zjsgfa.project.zjsgfa.domain.Mxfxjgb;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbService;

/**
 * 大模型分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
@Service
public class MxfxjgbServiceImpl implements IMxfxjgbService 
{
    @Autowired
    private MxfxjgbMapper mxfxjgbMapper;

    /**
     * 查询大模型分析
     * 
     * @param id 大模型分析主键
     * @return 大模型分析
     */
    @Override
    public Mxfxjgb selectMxfxjgbById(Long id)
    {
        return mxfxjgbMapper.selectMxfxjgbById(id);
    }

    /**
     * 查询大模型分析列表
     * 
     * @param mxfxjgb 大模型分析
     * @return 大模型分析
     */
    @Override
    public List<Mxfxjgb> selectMxfxjgbList(Mxfxjgb mxfxjgb)
    {
        return mxfxjgbMapper.selectMxfxjgbList(mxfxjgb);
    }

    /**
     * 新增大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    @Override
    public int insertMxfxjgb(Mxfxjgb mxfxjgb)
    {
        return mxfxjgbMapper.insertMxfxjgb(mxfxjgb);
    }

    /**
     * 修改大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    @Override
    public int updateMxfxjgb(Mxfxjgb mxfxjgb)
    {
        mxfxjgb.setUpdateTime(DateUtils.getNowDate());
        return mxfxjgbMapper.updateMxfxjgb(mxfxjgb);
    }

    /**
     * 批量删除大模型分析
     * 
     * @param ids 需要删除的大模型分析主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbByIds(Long[] ids)
    {
        return mxfxjgbMapper.deleteMxfxjgbByIds(ids);
    }

    /**
     * 删除大模型分析信息
     * 
     * @param id 大模型分析主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbById(Long id)
    {
        return mxfxjgbMapper.deleteMxfxjgbById(id);
    }
}
