package com.zjsgfa.project.zt.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zt.domain.LjZtdfzh;
import com.zjsgfa.project.zt.service.ILjZtdfzhService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 邻井-钻头得分综合Controller
 * 
 * @author ruoyi
 * @date 2025-06-30
 */
@RestController
@RequestMapping("/system/ljZtdfzh")
public class LjZtdfzhController extends BaseController
{
    @Autowired
    private ILjZtdfzhService ljZtdfzhService;

    /**
     * 查询邻井-钻头得分综合列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:list')")
    @GetMapping("/list")
    public TableDataInfo list(LjZtdfzh ljZtdfzh)
    {
        startPage();
        List<LjZtdfzh> list = ljZtdfzhService.selectLjZtdfzhList(ljZtdfzh);
        return getDataTable(list);
    }

    /**
     * 导出邻井-钻头得分综合列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:export')")
    @Log(title = "邻井-钻头得分综合", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LjZtdfzh ljZtdfzh)
    {
        List<LjZtdfzh> list = ljZtdfzhService.selectLjZtdfzhList(ljZtdfzh);
        ExcelUtil<LjZtdfzh> util = new ExcelUtil<LjZtdfzh>(LjZtdfzh.class);
        util.exportExcel(response, list, "邻井-钻头得分综合数据");
    }

    /**
     * 获取邻井-钻头得分综合详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ljZtdfzhService.selectLjZtdfzhById(id));
    }

    /**
     * 新增邻井-钻头得分综合
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:add')")
    @Log(title = "邻井-钻头得分综合", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LjZtdfzh ljZtdfzh)
    {
        return toAjax(ljZtdfzhService.insertLjZtdfzh(ljZtdfzh));
    }

    /**
     * 修改邻井-钻头得分综合
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:edit')")
    @Log(title = "邻井-钻头得分综合", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LjZtdfzh ljZtdfzh)
    {
        return toAjax(ljZtdfzhService.updateLjZtdfzh(ljZtdfzh));
    }

    /**
     * 删除邻井-钻头得分综合
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtdfzh:remove')")
    @Log(title = "邻井-钻头得分综合", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ljZtdfzhService.deleteLjZtdfzhByIds(ids));
    }
}
