package com.zjsgfa.project.zt.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zt.domain.LjSzfxjg;
import com.zjsgfa.project.zt.service.ILjSzfxjgService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 邻井-实钻分析结果Controller
 * 
 * @author ruoyi
 * @date 2025-06-29
 */
@RestController
@RequestMapping("/system/ljSzfxjg")
public class LjSzfxjgController extends BaseController
{
    @Autowired
    private ILjSzfxjgService ljSzfxjgService;

    /**
     * 查询邻井-实钻分析结果列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:list')")
    @GetMapping("/list")
    public TableDataInfo list(LjSzfxjg ljSzfxjg)
    {
        startPage();
        List<LjSzfxjg> list = ljSzfxjgService.selectLjSzfxjgList(ljSzfxjg);
        return getDataTable(list);
    }

    /**
     * 导出邻井-实钻分析结果列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:export')")
    @Log(title = "邻井-实钻分析结果", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LjSzfxjg ljSzfxjg)
    {
        List<LjSzfxjg> list = ljSzfxjgService.selectLjSzfxjgList(ljSzfxjg);
        ExcelUtil<LjSzfxjg> util = new ExcelUtil<LjSzfxjg>(LjSzfxjg.class);
        util.exportExcel(response, list, "邻井-实钻分析结果数据");
    }

    /**
     * 获取邻井-实钻分析结果详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ljSzfxjgService.selectLjSzfxjgById(id));
    }

    /**
     * 新增邻井-实钻分析结果
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:add')")
    @Log(title = "邻井-实钻分析结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LjSzfxjg ljSzfxjg)
    {
        return toAjax(ljSzfxjgService.insertLjSzfxjg(ljSzfxjg));
    }

    /**
     * 修改邻井-实钻分析结果
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:edit')")
    @Log(title = "邻井-实钻分析结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LjSzfxjg ljSzfxjg)
    {
        return toAjax(ljSzfxjgService.updateLjSzfxjg(ljSzfxjg));
    }

    /**
     * 删除邻井-实钻分析结果
     */
    @PreAuthorize("@ss.hasPermi('system:ljSzfxjg:remove')")
    @Log(title = "邻井-实钻分析结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ljSzfxjgService.deleteLjSzfxjgByIds(ids));
    }
}
