package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZtgjsjMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZtgjsj;
import com.zjsgfa.project.zjsgfa.service.ISjZtgjsjService;

/**
 * 设计-钻头关键数据分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Service
public class SjZtgjsjServiceImpl implements ISjZtgjsjService 
{
    @Autowired
    private SjZtgjsjMapper sjZtgjsjMapper;

    /**
     * 查询设计-钻头关键数据分析
     * 
     * @param id 设计-钻头关键数据分析主键
     * @return 设计-钻头关键数据分析
     */
    @Override
    public SjZtgjsj selectSjZtgjsjById(Long id)
    {
        return sjZtgjsjMapper.selectSjZtgjsjById(id);
    }

    /**
     * 查询设计-钻头关键数据分析列表
     * 
     * @param sjZtgjsj 设计-钻头关键数据分析
     * @return 设计-钻头关键数据分析
     */
    @Override
    public List<SjZtgjsj> selectSjZtgjsjList(SjZtgjsj sjZtgjsj)
    {
        return sjZtgjsjMapper.selectSjZtgjsjList(sjZtgjsj);
    }

    /**
     * 新增设计-钻头关键数据分析
     * 
     * @param sjZtgjsj 设计-钻头关键数据分析
     * @return 结果
     */
    @Override
    public int insertSjZtgjsj(SjZtgjsj sjZtgjsj)
    {
        return sjZtgjsjMapper.insertSjZtgjsj(sjZtgjsj);
    }

    /**
     * 修改设计-钻头关键数据分析
     * 
     * @param sjZtgjsj 设计-钻头关键数据分析
     * @return 结果
     */
    @Override
    public int updateSjZtgjsj(SjZtgjsj sjZtgjsj)
    {
        return sjZtgjsjMapper.updateSjZtgjsj(sjZtgjsj);
    }

    /**
     * 批量删除设计-钻头关键数据分析
     * 
     * @param ids 需要删除的设计-钻头关键数据分析主键
     * @return 结果
     */
    @Override
    public int deleteSjZtgjsjByIds(Long[] ids)
    {
        return sjZtgjsjMapper.deleteSjZtgjsjByIds(ids);
    }

    /**
     * 删除设计-钻头关键数据分析信息
     * 
     * @param id 设计-钻头关键数据分析主键
     * @return 结果
     */
    @Override
    public int deleteSjZtgjsjById(Long id)
    {
        return sjZtgjsjMapper.deleteSjZtgjsjById(id);
    }
}
