package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZsjqkMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZsjqk;
import com.zjsgfa.project.zjsgfa.service.ISjZsjqkService;

/**
 * 设计-注水井情况Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-05
 */
@Service
public class SjZsjqkServiceImpl implements ISjZsjqkService 
{
    @Autowired
    private SjZsjqkMapper sjZsjqkMapper;

    /**
     * 查询设计-注水井情况
     * 
     * @param sjjh 设计-注水井情况主键
     * @return 设计-注水井情况
     */
    @Override
    public SjZsjqk selectSjZsjqkBySjjh(String sjjh)
    {
        return sjZsjqkMapper.selectSjZsjqkBySjjh(sjjh);
    }

    /**
     * 查询设计-注水井情况列表
     * 
     * @param sjZsjqk 设计-注水井情况
     * @return 设计-注水井情况
     */
    @Override
    public List<SjZsjqk> selectSjZsjqkList(SjZsjqk sjZsjqk)
    {
        return sjZsjqkMapper.selectSjZsjqkList(sjZsjqk);
    }

    /**
     * 新增设计-注水井情况
     * 
     * @param sjZsjqk 设计-注水井情况
     * @return 结果
     */
    @Override
    public int insertSjZsjqk(SjZsjqk sjZsjqk)
    {
        return sjZsjqkMapper.insertSjZsjqk(sjZsjqk);
    }

    /**
     * 修改设计-注水井情况
     * 
     * @param sjZsjqk 设计-注水井情况
     * @return 结果
     */
    @Override
    public int updateSjZsjqk(SjZsjqk sjZsjqk)
    {
        return sjZsjqkMapper.updateSjZsjqk(sjZsjqk);
    }

    /**
     * 批量删除设计-注水井情况
     * 
     * @param sjjhs 需要删除的设计-注水井情况主键
     * @return 结果
     */
    @Override
    public int deleteSjZsjqkBySjjhs(String[] sjjhs)
    {
        return sjZsjqkMapper.deleteSjZsjqkBySjjhs(sjjhs);
    }

    /**
     * 删除设计-注水井情况信息
     * 
     * @param sjjh 设计-注水井情况主键
     * @return 结果
     */
    @Override
    public int deleteSjZsjqkBySjjh(String sjjh)
    {
        return sjZsjqkMapper.deleteSjZsjqkBySjjh(sjjh);
    }

    @Override
    public int insertSjZsjqkBatch(List<SjZsjqk> sjZsjqkList) {
        return sjZsjqkMapper.insertSjZsjqkBatch(sjZsjqkList);
    }
}
