package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZqfxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZqfx;
import com.zjsgfa.project.zjsgfa.service.ISjZqfxService;

/**
 * 设计-周期分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Service
public class SjZqfxServiceImpl implements ISjZqfxService 
{
    @Autowired
    private SjZqfxMapper sjZqfxMapper;

    /**
     * 查询设计-周期分析
     * 
     * @param id 设计-周期分析主键
     * @return 设计-周期分析
     */
    @Override
    public SjZqfx selectSjZqfxById(Long id)
    {
        return sjZqfxMapper.selectSjZqfxById(id);
    }

    /**
     * 查询设计-周期分析列表
     * 
     * @param sjZqfx 设计-周期分析
     * @return 设计-周期分析
     */
    @Override
    public List<SjZqfx> selectSjZqfxList(SjZqfx sjZqfx)
    {
        return sjZqfxMapper.selectSjZqfxList(sjZqfx);
    }

    /**
     * 新增设计-周期分析
     * 
     * @param sjZqfx 设计-周期分析
     * @return 结果
     */
    @Override
    public int insertSjZqfx(SjZqfx sjZqfx)
    {
        return sjZqfxMapper.insertSjZqfx(sjZqfx);
    }

    /**
     * 修改设计-周期分析
     * 
     * @param sjZqfx 设计-周期分析
     * @return 结果
     */
    @Override
    public int updateSjZqfx(SjZqfx sjZqfx)
    {
        return sjZqfxMapper.updateSjZqfx(sjZqfx);
    }

    /**
     * 批量删除设计-周期分析
     * 
     * @param ids 需要删除的设计-周期分析主键
     * @return 结果
     */
    @Override
    public int deleteSjZqfxByIds(Long[] ids)
    {
        return sjZqfxMapper.deleteSjZqfxByIds(ids);
    }

    /**
     * 删除设计-周期分析信息
     * 
     * @param id 设计-周期分析主键
     * @return 结果
     */
    @Override
    public int deleteSjZqfxById(Long id)
    {
        return sjZqfxMapper.deleteSjZqfxById(id);
    }
}
