package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZlyqMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZlyq;
import com.zjsgfa.project.zjsgfa.service.ISjZlyqService;

/**
 * 设计信息-井身质量要求Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjZlyqServiceImpl implements ISjZlyqService 
{
    @Autowired
    private SjZlyqMapper sjZlyqMapper;

    /**
     * 查询设计信息-井身质量要求
     * 
     * @param id 设计信息-井身质量要求主键
     * @return 设计信息-井身质量要求
     */
    @Override
    public SjZlyq selectSjZlyqById(Long id)
    {
        return sjZlyqMapper.selectSjZlyqById(id);
    }

    /**
     * 查询设计信息-井身质量要求列表
     * 
     * @param sjZlyq 设计信息-井身质量要求
     * @return 设计信息-井身质量要求
     */
    @Override
    public List<SjZlyq> selectSjZlyqList(SjZlyq sjZlyq)
    {
        return sjZlyqMapper.selectSjZlyqList(sjZlyq);
    }

    /**
     * 新增设计信息-井身质量要求
     * 
     * @param sjZlyq 设计信息-井身质量要求
     * @return 结果
     */
    @Override
    public int insertSjZlyq(SjZlyq sjZlyq)
    {
        return sjZlyqMapper.insertSjZlyq(sjZlyq);
    }

    /**
     * 修改设计信息-井身质量要求
     * 
     * @param sjZlyq 设计信息-井身质量要求
     * @return 结果
     */
    @Override
    public int updateSjZlyq(SjZlyq sjZlyq)
    {
        sjZlyq.setUpdateTime(DateUtils.getNowDate());
        return sjZlyqMapper.updateSjZlyq(sjZlyq);
    }

    /**
     * 批量删除设计信息-井身质量要求
     * 
     * @param ids 需要删除的设计信息-井身质量要求主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqByIds(Long[] ids)
    {
        return sjZlyqMapper.deleteSjZlyqByIds(ids);
    }

    /**
     * 删除设计信息-井身质量要求信息
     * 
     * @param id 设计信息-井身质量要求主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqById(Long id)
    {
        return sjZlyqMapper.deleteSjZlyqById(id);
    }
}
