package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZjyFdsjMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZjyFdsj;
import com.zjsgfa.project.zjsgfa.service.ISjZjyFdsjService;

/**
 * 设计信息-分段钻井液设计Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjZjyFdsjServiceImpl implements ISjZjyFdsjService 
{
    @Autowired
    private SjZjyFdsjMapper sjZjyFdsjMapper;

    /**
     * 查询设计信息-分段钻井液设计
     * 
     * @param id 设计信息-分段钻井液设计主键
     * @return 设计信息-分段钻井液设计
     */
    @Override
    public SjZjyFdsj selectSjZjyFdsjById(Long id)
    {
        return sjZjyFdsjMapper.selectSjZjyFdsjById(id);
    }

    /**
     * 查询设计信息-分段钻井液设计列表
     * 
     * @param sjZjyFdsj 设计信息-分段钻井液设计
     * @return 设计信息-分段钻井液设计
     */
    @Override
    public List<SjZjyFdsj> selectSjZjyFdsjList(SjZjyFdsj sjZjyFdsj)
    {
        return sjZjyFdsjMapper.selectSjZjyFdsjList(sjZjyFdsj);
    }

    /**
     * 新增设计信息-分段钻井液设计
     * 
     * @param sjZjyFdsj 设计信息-分段钻井液设计
     * @return 结果
     */
    @Override
    public int insertSjZjyFdsj(SjZjyFdsj sjZjyFdsj)
    {
        return sjZjyFdsjMapper.insertSjZjyFdsj(sjZjyFdsj);
    }

    /**
     * 修改设计信息-分段钻井液设计
     * 
     * @param sjZjyFdsj 设计信息-分段钻井液设计
     * @return 结果
     */
    @Override
    public int updateSjZjyFdsj(SjZjyFdsj sjZjyFdsj)
    {
        sjZjyFdsj.setUpdateTime(DateUtils.getNowDate());
        return sjZjyFdsjMapper.updateSjZjyFdsj(sjZjyFdsj);
    }

    /**
     * 批量删除设计信息-分段钻井液设计
     * 
     * @param ids 需要删除的设计信息-分段钻井液设计主键
     * @return 结果
     */
    @Override
    public int deleteSjZjyFdsjByIds(Long[] ids)
    {
        return sjZjyFdsjMapper.deleteSjZjyFdsjByIds(ids);
    }

    /**
     * 删除设计信息-分段钻井液设计信息
     * 
     * @param id 设计信息-分段钻井液设计主键
     * @return 结果
     */
    @Override
    public int deleteSjZjyFdsjById(Long id)
    {
        return sjZjyFdsjMapper.deleteSjZjyFdsjById(id);
    }
}
