package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjTgTgxnsjMapper;
import com.zjsgfa.project.zjsgfa.domain.SjTgTgxnsj;
import com.zjsgfa.project.zjsgfa.service.ISjTgTgxnsjService;

/**
 * 设计信息-套管性能数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjTgTgxnsjServiceImpl implements ISjTgTgxnsjService 
{
    @Autowired
    private SjTgTgxnsjMapper sjTgTgxnsjMapper;

    /**
     * 查询设计信息-套管性能数据
     * 
     * @param id 设计信息-套管性能数据主键
     * @return 设计信息-套管性能数据
     */
    @Override
    public SjTgTgxnsj selectSjTgTgxnsjById(Long id)
    {
        return sjTgTgxnsjMapper.selectSjTgTgxnsjById(id);
    }

    /**
     * 查询设计信息-套管性能数据列表
     * 
     * @param sjTgTgxnsj 设计信息-套管性能数据
     * @return 设计信息-套管性能数据
     */
    @Override
    public List<SjTgTgxnsj> selectSjTgTgxnsjList(SjTgTgxnsj sjTgTgxnsj)
    {
        return sjTgTgxnsjMapper.selectSjTgTgxnsjList(sjTgTgxnsj);
    }

    /**
     * 新增设计信息-套管性能数据
     * 
     * @param sjTgTgxnsj 设计信息-套管性能数据
     * @return 结果
     */
    @Override
    public int insertSjTgTgxnsj(SjTgTgxnsj sjTgTgxnsj)
    {
        return sjTgTgxnsjMapper.insertSjTgTgxnsj(sjTgTgxnsj);
    }

    /**
     * 修改设计信息-套管性能数据
     * 
     * @param sjTgTgxnsj 设计信息-套管性能数据
     * @return 结果
     */
    @Override
    public int updateSjTgTgxnsj(SjTgTgxnsj sjTgTgxnsj)
    {
        sjTgTgxnsj.setUpdateTime(DateUtils.getNowDate());
        return sjTgTgxnsjMapper.updateSjTgTgxnsj(sjTgTgxnsj);
    }

    /**
     * 批量删除设计信息-套管性能数据
     * 
     * @param ids 需要删除的设计信息-套管性能数据主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgxnsjByIds(Long[] ids)
    {
        return sjTgTgxnsjMapper.deleteSjTgTgxnsjByIds(ids);
    }

    /**
     * 删除设计信息-套管性能数据信息
     * 
     * @param id 设计信息-套管性能数据主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgxnsjById(Long id)
    {
        return sjTgTgxnsjMapper.deleteSjTgTgxnsjById(id);
    }
}
