package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjSggyZjyFdsjMapper;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjyFdsj;
import com.zjsgfa.project.zjsgfa.service.ISjSggyZjyFdsjService;

/**
 * 设计信息-施工概要-分段钻井液设计Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@Service
public class SjSggyZjyFdsjServiceImpl implements ISjSggyZjyFdsjService 
{
    @Autowired
    private SjSggyZjyFdsjMapper sjSggyZjyFdsjMapper;

    /**
     * 查询设计信息-施工概要-分段钻井液设计
     * 
     * @param id 设计信息-施工概要-分段钻井液设计主键
     * @return 设计信息-施工概要-分段钻井液设计
     */
    @Override
    public SjSggyZjyFdsj selectSjSggyZjyFdsjById(Long id)
    {
        return sjSggyZjyFdsjMapper.selectSjSggyZjyFdsjById(id);
    }

    /**
     * 查询设计信息-施工概要-分段钻井液设计列表
     * 
     * @param sjSggyZjyFdsj 设计信息-施工概要-分段钻井液设计
     * @return 设计信息-施工概要-分段钻井液设计
     */
    @Override
    public List<SjSggyZjyFdsj> selectSjSggyZjyFdsjList(SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        return sjSggyZjyFdsjMapper.selectSjSggyZjyFdsjList(sjSggyZjyFdsj);
    }

    /**
     * 新增设计信息-施工概要-分段钻井液设计
     * 
     * @param sjSggyZjyFdsj 设计信息-施工概要-分段钻井液设计
     * @return 结果
     */
    @Override
    public int insertSjSggyZjyFdsj(SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        return sjSggyZjyFdsjMapper.insertSjSggyZjyFdsj(sjSggyZjyFdsj);
    }

    /**
     * 修改设计信息-施工概要-分段钻井液设计
     * 
     * @param sjSggyZjyFdsj 设计信息-施工概要-分段钻井液设计
     * @return 结果
     */
    @Override
    public int updateSjSggyZjyFdsj(SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        sjSggyZjyFdsj.setUpdateTime(DateUtils.getNowDate());
        return sjSggyZjyFdsjMapper.updateSjSggyZjyFdsj(sjSggyZjyFdsj);
    }

    /**
     * 批量删除设计信息-施工概要-分段钻井液设计
     * 
     * @param ids 需要删除的设计信息-施工概要-分段钻井液设计主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyZjyFdsjByIds(Long[] ids)
    {
        return sjSggyZjyFdsjMapper.deleteSjSggyZjyFdsjByIds(ids);
    }

    /**
     * 删除设计信息-施工概要-分段钻井液设计信息
     * 
     * @param id 设计信息-施工概要-分段钻井液设计主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyZjyFdsjById(Long id)
    {
        return sjSggyZjyFdsjMapper.deleteSjSggyZjyFdsjById(id);
    }
}
