package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjJygjGdfdcsMapper;
import com.zjsgfa.project.zjsgfa.domain.SjJygjGdfdcs;
import com.zjsgfa.project.zjsgfa.service.ISjJygjGdfdcsService;

/**
 * 设计信息-井眼轨迹_轨道分段参数Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-26
 */
@Service
public class SjJygjGdfdcsServiceImpl implements ISjJygjGdfdcsService 
{
    @Autowired
    private SjJygjGdfdcsMapper sjJygjGdfdcsMapper;

    /**
     * 查询设计信息-井眼轨迹_轨道分段参数
     * 
     * @param id 设计信息-井眼轨迹_轨道分段参数主键
     * @return 设计信息-井眼轨迹_轨道分段参数
     */
    @Override
    public SjJygjGdfdcs selectSjJygjGdfdcsById(Long id)
    {
        return sjJygjGdfdcsMapper.selectSjJygjGdfdcsById(id);
    }

    /**
     * 查询设计信息-井眼轨迹_轨道分段参数列表
     * 
     * @param sjJygjGdfdcs 设计信息-井眼轨迹_轨道分段参数
     * @return 设计信息-井眼轨迹_轨道分段参数
     */
    @Override
    public List<SjJygjGdfdcs> selectSjJygjGdfdcsList(SjJygjGdfdcs sjJygjGdfdcs)
    {
        return sjJygjGdfdcsMapper.selectSjJygjGdfdcsList(sjJygjGdfdcs);
    }

    /**
     * 新增设计信息-井眼轨迹_轨道分段参数
     * 
     * @param sjJygjGdfdcs 设计信息-井眼轨迹_轨道分段参数
     * @return 结果
     */
    @Override
    public int insertSjJygjGdfdcs(SjJygjGdfdcs sjJygjGdfdcs)
    {
        return sjJygjGdfdcsMapper.insertSjJygjGdfdcs(sjJygjGdfdcs);
    }

    /**
     * 修改设计信息-井眼轨迹_轨道分段参数
     * 
     * @param sjJygjGdfdcs 设计信息-井眼轨迹_轨道分段参数
     * @return 结果
     */
    @Override
    public int updateSjJygjGdfdcs(SjJygjGdfdcs sjJygjGdfdcs)
    {
        sjJygjGdfdcs.setUpdateTime(DateUtils.getNowDate());
        return sjJygjGdfdcsMapper.updateSjJygjGdfdcs(sjJygjGdfdcs);
    }

    /**
     * 批量删除设计信息-井眼轨迹_轨道分段参数
     * 
     * @param ids 需要删除的设计信息-井眼轨迹_轨道分段参数主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjGdfdcsByIds(Long[] ids)
    {
        return sjJygjGdfdcsMapper.deleteSjJygjGdfdcsByIds(ids);
    }

    /**
     * 删除设计信息-井眼轨迹_轨道分段参数信息
     * 
     * @param id 设计信息-井眼轨迹_轨道分段参数主键
     * @return 结果
     */
    @Override
    public int deleteSjJygjGdfdcsById(Long id)
    {
        return sjJygjGdfdcsMapper.deleteSjJygjGdfdcsById(id);
    }
}
