package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.framework.util.RichTextProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjHseMapper;
import com.zjsgfa.project.zjsgfa.domain.SjHse;
import com.zjsgfa.project.zjsgfa.service.ISjHseService;

/**
 * 设计-HSE专篇Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-24
 */
@Service
public class SjHseServiceImpl implements ISjHseService 
{
    @Autowired
    private SjHseMapper sjHseMapper;

    /**
     * 查询设计-HSE专篇
     * 
     * @param id 设计-HSE专篇主键
     * @return 设计-HSE专篇
     */
    @Override
    public SjHse selectSjHseById(Long id)
    {
        SjHse sjHse = sjHseMapper.selectSjHseById(id);
        // 压缩富文本中的图片，设置质量和最大尺寸
        String compressedContent = RichTextProcessor.processRichText(
                sjHse.getHse(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        sjHse.setHse(compressedContent);
        return sjHse;
    }

    /**
     * 查询设计-HSE专篇列表
     * 
     * @param sjHse 设计-HSE专篇
     * @return 设计-HSE专篇
     */
    @Override
    public List<SjHse> selectSjHseList(SjHse sjHse)
    {
        List<SjHse> list = sjHseMapper.selectSjHseList(sjHse);
        list.stream().map(entity -> {
            // 压缩富文本中的图片，设置质量和最大尺寸
            String compressedContent = RichTextProcessor.processRichText(
                    entity.getHse(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setHse(compressedContent);
            return entity;
        }).collect(Collectors.toList());
        return list;
    }

    /**
     * 新增设计-HSE专篇
     * 
     * @param sjHse 设计-HSE专篇
     * @return 结果
     */
    @Override
    public int insertSjHse(SjHse sjHse)
    {

        //解密
        if(StringUtils.isNotEmpty(sjHse.getHse())){
            String s = new String(Base64.decode(sjHse.getHse()));
            sjHse.setHse(s);
        }
        return sjHseMapper.insertSjHse(sjHse);
    }

    /**
     * 修改设计-HSE专篇
     * 
     * @param sjHse 设计-HSE专篇
     * @return 结果
     */
    @Override
    public int updateSjHse(SjHse sjHse)
    {
        //解密
        if(StringUtils.isNotEmpty(sjHse.getHse())){
            String s = new String(Base64.decode(sjHse.getHse()));
            sjHse.setHse(s);
        }

        sjHse.setUpdateTime(DateUtils.getNowDate());
        return sjHseMapper.updateSjHse(sjHse);
    }

    /**
     * 批量删除设计-HSE专篇
     * 
     * @param ids 需要删除的设计-HSE专篇主键
     * @return 结果
     */
    @Override
    public int deleteSjHseByIds(Long[] ids)
    {
        return sjHseMapper.deleteSjHseByIds(ids);
    }

    /**
     * 删除设计-HSE专篇信息
     * 
     * @param id 设计-HSE专篇主键
     * @return 结果
     */
    @Override
    public int deleteSjHseById(Long id)
    {
        return sjHseMapper.deleteSjHseById(id);
    }
}
