package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjGztzMapper;
import com.zjsgfa.project.zjsgfa.domain.SjGztz;
import com.zjsgfa.project.zjsgfa.service.ISjGztzService;

/**
 * 设计信息-构造特征Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Service
public class SjGztzServiceImpl implements ISjGztzService 
{
    @Autowired
    private SjGztzMapper sjGztzMapper;

    /**
     * 查询设计信息-构造特征
     * 
     * @param id 设计信息-构造特征主键
     * @return 设计信息-构造特征
     */
    @Override
    public SjGztz selectSjGztzById(Long id)
    {
        return sjGztzMapper.selectSjGztzById(id);
    }

    /**
     * 查询设计信息-构造特征列表
     * 
     * @param sjGztz 设计信息-构造特征
     * @return 设计信息-构造特征
     */
    @Override
    public List<SjGztz> selectSjGztzList(SjGztz sjGztz)
    {
        return sjGztzMapper.selectSjGztzList(sjGztz);
    }

    /**
     * 新增设计信息-构造特征
     * 
     * @param sjGztz 设计信息-构造特征
     * @return 结果
     */
    @Override
    public int insertSjGztz(SjGztz sjGztz)
    {
        return sjGztzMapper.insertSjGztz(sjGztz);
    }

    /**
     * 修改设计信息-构造特征
     * 
     * @param sjGztz 设计信息-构造特征
     * @return 结果
     */
    @Override
    public int updateSjGztz(SjGztz sjGztz)
    {
        sjGztz.setUpdateTime(DateUtils.getNowDate());
        return sjGztzMapper.updateSjGztz(sjGztz);
    }

    /**
     * 批量删除设计信息-构造特征
     * 
     * @param ids 需要删除的设计信息-构造特征主键
     * @return 结果
     */
    @Override
    public int deleteSjGztzByIds(Long[] ids)
    {
        return sjGztzMapper.deleteSjGztzByIds(ids);
    }

    /**
     * 删除设计信息-构造特征信息
     * 
     * @param id 设计信息-构造特征主键
     * @return 结果
     */
    @Override
    public int deleteSjGztzById(Long id)
    {
        return sjGztzMapper.deleteSjGztzById(id);
    }
}
