package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.JcxxTsgjMapper;
import com.zjsgfa.project.zjsgfa.domain.JcxxTsgj;
import com.zjsgfa.project.zjsgfa.service.IJcxxTsgjService;

/**
 * 基础信息_特殊工具Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
@Service
public class JcxxTsgjServiceImpl implements IJcxxTsgjService 
{
    @Autowired
    private JcxxTsgjMapper jcxxTsgjMapper;

    /**
     * 查询基础信息_特殊工具
     * 
     * @param id 基础信息_特殊工具主键
     * @return 基础信息_特殊工具
     */
    @Override
    public JcxxTsgj selectJcxxTsgjById(Long id)
    {
        return jcxxTsgjMapper.selectJcxxTsgjById(id);
    }

    /**
     * 查询基础信息_特殊工具列表
     * 
     * @param jcxxTsgj 基础信息_特殊工具
     * @return 基础信息_特殊工具
     */
    @Override
    public List<JcxxTsgj> selectJcxxTsgjList(JcxxTsgj jcxxTsgj)
    {
        return jcxxTsgjMapper.selectJcxxTsgjList(jcxxTsgj);
    }

    /**
     * 新增基础信息_特殊工具
     * 
     * @param jcxxTsgj 基础信息_特殊工具
     * @return 结果
     */
    @Override
    public int insertJcxxTsgj(JcxxTsgj jcxxTsgj)
    {
        return jcxxTsgjMapper.insertJcxxTsgj(jcxxTsgj);
    }

    /**
     * 修改基础信息_特殊工具
     * 
     * @param jcxxTsgj 基础信息_特殊工具
     * @return 结果
     */
    @Override
    public int updateJcxxTsgj(JcxxTsgj jcxxTsgj)
    {
        return jcxxTsgjMapper.updateJcxxTsgj(jcxxTsgj);
    }

    /**
     * 批量删除基础信息_特殊工具
     * 
     * @param ids 需要删除的基础信息_特殊工具主键
     * @return 结果
     */
    @Override
    public int deleteJcxxTsgjByIds(Long[] ids)
    {
        return jcxxTsgjMapper.deleteJcxxTsgjByIds(ids);
    }

    /**
     * 删除基础信息_特殊工具信息
     * 
     * @param id 基础信息_特殊工具主键
     * @return 结果
     */
    @Override
    public int deleteJcxxTsgjById(Long id)
    {
        return jcxxTsgjMapper.deleteJcxxTsgjById(id);
    }
}
