package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.DzgzzbMapper;
import com.zjsgfa.project.zjsgfa.domain.Dzgzzb;
import com.zjsgfa.project.zjsgfa.service.IDzgzzbService;

/**
 * 地质构造总Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-08
 */
@Service
public class DzgzzbServiceImpl implements IDzgzzbService 
{
    @Autowired
    private DzgzzbMapper dzgzzbMapper;

    /**
     * 查询地质构造总
     * 
     * @param id 地质构造总主键
     * @return 地质构造总
     */
    @Override
    public Dzgzzb selectDzgzzbById(Long id)
    {
        return dzgzzbMapper.selectDzgzzbById(id);
    }

    /**
     * 查询地质构造总列表
     * 
     * @param dzgzzb 地质构造总
     * @return 地质构造总
     */
    @Override
    public List<Dzgzzb> selectDzgzzbList(Dzgzzb dzgzzb)
    {
        return dzgzzbMapper.selectDzgzzbList(dzgzzb);
    }

    /**
     * 新增地质构造总
     * 
     * @param dzgzzb 地质构造总
     * @return 结果
     */
    @Override
    public int insertDzgzzb(Dzgzzb dzgzzb)
    {
        return dzgzzbMapper.insertDzgzzb(dzgzzb);
    }

    /**
     * 修改地质构造总
     * 
     * @param dzgzzb 地质构造总
     * @return 结果
     */
    @Override
    public int updateDzgzzb(Dzgzzb dzgzzb)
    {
        return dzgzzbMapper.updateDzgzzb(dzgzzb);
    }

    /**
     * 批量删除地质构造总
     * 
     * @param ids 需要删除的地质构造总主键
     * @return 结果
     */
    @Override
    public int deleteDzgzzbByIds(Long[] ids)
    {
        return dzgzzbMapper.deleteDzgzzbByIds(ids);
    }

    /**
     * 删除地质构造总信息
     * 
     * @param id 地质构造总主键
     * @return 结果
     */
    @Override
    public int deleteDzgzzbById(Long id)
    {
        return dzgzzbMapper.deleteDzgzzbById(id);
    }
}
