package com.zjsgfa.project.zjsgfa.service;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.SjH2s;

/**
 * 设计信息-H2SService接口
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
public interface ISjH2sService 
{
    /**
     * 查询设计信息-H2S
     * 
     * @param id 设计信息-H2S主键
     * @return 设计信息-H2S
     */
    public SjH2s selectSjH2sById(Long id);

    /**
     * 查询设计信息-H2S列表
     * 
     * @param sjH2s 设计信息-H2S
     * @return 设计信息-H2S集合
     */
    public List<SjH2s> selectSjH2sList(SjH2s sjH2s);

    /**
     * 新增设计信息-H2S
     * 
     * @param sjH2s 设计信息-H2S
     * @return 结果
     */
    public int insertSjH2s(SjH2s sjH2s);

    /**
     * 修改设计信息-H2S
     * 
     * @param sjH2s 设计信息-H2S
     * @return 结果
     */
    public int updateSjH2s(SjH2s sjH2s);

    /**
     * 批量删除设计信息-H2S
     * 
     * @param ids 需要删除的设计信息-H2S主键集合
     * @return 结果
     */
    public int deleteSjH2sByIds(Long[] ids);

    /**
     * 删除设计信息-H2S信息
     * 
     * @param id 设计信息-H2S主键
     * @return 结果
     */
    public int deleteSjH2sById(Long id);
}
