package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;

import com.zjsgfa.framework.aspectj.lang.annotation.DataSource;
import com.zjsgfa.framework.aspectj.lang.enums.DataSourceType;
import com.zjsgfa.project.zjsgfa.domain.Tsyxclxx;

/**
 * 特殊岩性常量信息Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-08
 */
@DataSource(value = DataSourceType.MASTER)
public interface TsyxclxxMapper 
{
    /**
     * 查询特殊岩性常量信息
     * 
     * @param id 特殊岩性常量信息主键
     * @return 特殊岩性常量信息
     */
    public Tsyxclxx selectTsyxclxxById(Long id);

    /**
     * 查询特殊岩性常量信息列表
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 特殊岩性常量信息集合
     */
    public List<Tsyxclxx> selectTsyxclxxList(Tsyxclxx tsyxclxx);

    /**
     * 新增特殊岩性常量信息
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 结果
     */
    public int insertTsyxclxx(Tsyxclxx tsyxclxx);

    /**
     * 修改特殊岩性常量信息
     * 
     * @param tsyxclxx 特殊岩性常量信息
     * @return 结果
     */
    public int updateTsyxclxx(Tsyxclxx tsyxclxx);

    /**
     * 删除特殊岩性常量信息
     * 
     * @param id 特殊岩性常量信息主键
     * @return 结果
     */
    public int deleteTsyxclxxById(Long id);

    /**
     * 批量删除特殊岩性常量信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTsyxclxxByIds(Long[] ids);
}
