package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.SjLjsm;

/**
 * 设计信息-邻井扫描Mapper接口
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
public interface SjLjsmMapper 
{
    /**
     * 查询设计信息-邻井扫描
     * 
     * @param id 设计信息-邻井扫描主键
     * @return 设计信息-邻井扫描
     */
    public SjLjsm selectSjLjsmById(Long id);

    /**
     * 查询设计信息-邻井扫描列表
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 设计信息-邻井扫描集合
     */
    public List<SjLjsm> selectSjLjsmList(SjLjsm sjLjsm);

    /**
     * 新增设计信息-邻井扫描
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 结果
     */
    public int insertSjLjsm(SjLjsm sjLjsm);

    /**
     * 修改设计信息-邻井扫描
     * 
     * @param sjLjsm 设计信息-邻井扫描
     * @return 结果
     */
    public int updateSjLjsm(SjLjsm sjLjsm);

    /**
     * 删除设计信息-邻井扫描
     * 
     * @param id 设计信息-邻井扫描主键
     * @return 结果
     */
    public int deleteSjLjsmById(Long id);

    /**
     * 批量删除设计信息-邻井扫描
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjLjsmByIds(Long[] ids);

    int deleteSjLjsmByJh(String jh);

    int insertSjLjsmBatch(List<SjLjsm> sjLjsmList);

}
