package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.ClFxsb;

/**
 * 常量-风险识别字典Mapper接口
 * 
 * @author ruoyi
 * @date 2025-08-13
 */
public interface ClFxsbMapper 
{
    /**
     * 查询常量-风险识别字典
     * 
     * @param id 常量-风险识别字典主键
     * @return 常量-风险识别字典
     */
    public ClFxsb selectClFxsbById(Long id);

    /**
     * 查询常量-风险识别字典列表
     * 
     * @param clFxsb 常量-风险识别字典
     * @return 常量-风险识别字典集合
     */
    public List<ClFxsb> selectClFxsbList(ClFxsb clFxsb);

    /**
     * 新增常量-风险识别字典
     * 
     * @param clFxsb 常量-风险识别字典
     * @return 结果
     */
    public int insertClFxsb(ClFxsb clFxsb);

    /**
     * 修改常量-风险识别字典
     * 
     * @param clFxsb 常量-风险识别字典
     * @return 结果
     */
    public int updateClFxsb(ClFxsb clFxsb);

    /**
     * 删除常量-风险识别字典
     * 
     * @param id 常量-风险识别字典主键
     * @return 结果
     */
    public int deleteClFxsbById(Long id);

    /**
     * 批量删除常量-风险识别字典
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteClFxsbByIds(Long[] ids);
}
