package com.zjsgfa.project.zjsgfa.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 特殊岩性常量信息对象 tsyxclxx
 * 
 * @author ruoyi
 * @date 2025-07-08
 */
@Data
public class Tsyxclxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 特殊岩性 */
    @Excel(name = "特殊岩性")
    private String tsyx;
    private String[] tsyxs;

    /** 补充描述 */
    @Excel(name = "补充描述")
    private String bcms;

    /** 识别方式 */
    @Excel(name = "识别方式")
    private String sbfs;

    /** 危害、可能造成的问题 */
    @Excel(name = "危害、可能造成的问题")
    private String wt;

    /** 建议的预防类措施 */
    @Excel(name = "建议的预防类措施")
    private String yfcs;

    /** 建议的应急处理类措施 */
    @Excel(name = "建议的应急处理类措施")
    private String yjcs;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setTsyx(String tsyx) 
    {
        this.tsyx = tsyx;
    }

    public String getTsyx() 
    {
        return tsyx;
    }

    public void setBcms(String bcms) 
    {
        this.bcms = bcms;
    }

    public String getBcms() 
    {
        return bcms;
    }

    public void setSbfs(String sbfs) 
    {
        this.sbfs = sbfs;
    }

    public String getSbfs() 
    {
        return sbfs;
    }

    public void setWt(String wt) 
    {
        this.wt = wt;
    }

    public String getWt() 
    {
        return wt;
    }

    public void setYfcs(String yfcs) 
    {
        this.yfcs = yfcs;
    }

    public String getYfcs() 
    {
        return yfcs;
    }

    public void setYjcs(String yjcs) 
    {
        this.yjcs = yjcs;
    }

    public String getYjcs() 
    {
        return yjcs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("tsyx", getTsyx())
            .append("bcms", getBcms())
            .append("sbfs", getSbfs())
            .append("wt", getWt())
            .append("yfcs", getYfcs())
            .append("yjcs", getYjcs())
            .toString();
    }
}
