package com.zjsgfa.project.zjsgfa.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-注水井情况对象 sj_zsjqk
 * 
 * @author ruoyi
 * @date 2025-08-05
 */
public class SjZsjqk extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 实际井号 */
    @Excel(name = "实际井号")
    private String sjjh;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井号编码（中文井号） */
    @Excel(name = "井号编码", readConverterExp = "中=文井号")
    private String jhbm;

    /** 注入类型 */
    @Excel(name = "注入类型")
    private String zqlxmc;

    /** 注水层位 */
    @Excel(name = "注水层位")
    private String cwmc;

    /** 深度范围 */
    @Excel(name = "深度范围")
    private String sdfw;

    /** 井口压力 */
    @Excel(name = "井口压力")
    private Double jkyl;

    /** 地层压力 */
    @Excel(name = "地层压力")
    private Double dcyl;

    /** 日注量 */
    @Excel(name = "日注量")
    private Double rzl;

    /** 累计注入量 */
    @Excel(name = "累计注入量")
    private Double ljzrl;

    /** 注入状态 */
    @Excel(name = "注入状态")
    private String zrzt;

    /** 井口距离 */
    @Excel(name = "井口距离")
    private Double jkjl;

    /** 井底距离 */
    @Excel(name = "井底距离")
    private Double jdjl;

    /** 是否停驻 */
    @Excel(name = "是否停驻")
    private String sftz;

    public void setSjjh(String sjjh) 
    {
        this.sjjh = sjjh;
    }

    public String getSjjh() 
    {
        return sjjh;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJhbm(String jhbm) 
    {
        this.jhbm = jhbm;
    }

    public String getJhbm() 
    {
        return jhbm;
    }

    public void setZqlxmc(String zqlxmc) 
    {
        this.zqlxmc = zqlxmc;
    }

    public String getZqlxmc() 
    {
        return zqlxmc;
    }

    public void setCwmc(String cwmc) 
    {
        this.cwmc = cwmc;
    }

    public String getCwmc() 
    {
        return cwmc;
    }

    public void setSdfw(String sdfw) 
    {
        this.sdfw = sdfw;
    }

    public String getSdfw() 
    {
        return sdfw;
    }

    public void setJkyl(Double jkyl) 
    {
        this.jkyl = jkyl;
    }

    public Double getJkyl() 
    {
        return jkyl;
    }

    public void setDcyl(Double dcyl) 
    {
        this.dcyl = dcyl;
    }

    public Double getDcyl() 
    {
        return dcyl;
    }

    public void setRzl(Double rzl) 
    {
        this.rzl = rzl;
    }

    public Double getRzl() 
    {
        return rzl;
    }

    public void setLjzrl(Double ljzrl) 
    {
        this.ljzrl = ljzrl;
    }

    public Double getLjzrl() 
    {
        return ljzrl;
    }

    public void setZrzt(String zrzt) 
    {
        this.zrzt = zrzt;
    }

    public String getZrzt() 
    {
        return zrzt;
    }

    public void setJkjl(Double jkjl) 
    {
        this.jkjl = jkjl;
    }

    public Double getJkjl() 
    {
        return jkjl;
    }

    public void setJdjl(Double jdjl) 
    {
        this.jdjl = jdjl;
    }

    public Double getJdjl() 
    {
        return jdjl;
    }

    public void setSftz(String sftz) 
    {
        this.sftz = sftz;
    }

    public String getSftz() 
    {
        return sftz;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("sjjh", getSjjh())
            .append("jh", getJh())
            .append("jhbm", getJhbm())
            .append("zqlxmc", getZqlxmc())
            .append("cwmc", getCwmc())
            .append("sdfw", getSdfw())
            .append("jkyl", getJkyl())
            .append("dcyl", getDcyl())
            .append("rzl", getRzl())
            .append("ljzrl", getLjzrl())
            .append("zrzt", getZrzt())
            .append("jkjl", getJkjl())
            .append("jdjl", getJdjl())
            .append("sftz", getSftz())
            .toString();
    }
}
