package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井身质量要求详细对象 sj_zlyq_xx
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
public class SjZlyqXx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 定向井段井身质量要求 */
    @Excel(name = "定向井段井身质量要求")
    private String dxjzlyq;

    /** 固井质量要求 */
    @Excel(name = "固井质量要求")
    private String gjzlyq;

    /** 完成井井口质量要求 */
    @Excel(name = "完成井井口质量要求")
    private String wcjjkzlyq;

    /** 油气层污染判定要求 */
    @Excel(name = "油气层污染判定要求")
    private String yqcwrpdyq;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setDxjzlyq(String dxjzlyq) 
    {
        this.dxjzlyq = dxjzlyq;
    }

    public String getDxjzlyq() 
    {
        return dxjzlyq;
    }

    public void setGjzlyq(String gjzlyq) 
    {
        this.gjzlyq = gjzlyq;
    }

    public String getGjzlyq() 
    {
        return gjzlyq;
    }

    public void setWcjjkzlyq(String wcjjkzlyq) 
    {
        this.wcjjkzlyq = wcjjkzlyq;
    }

    public String getWcjjkzlyq() 
    {
        return wcjjkzlyq;
    }

    public void setYqcwrpdyq(String yqcwrpdyq) 
    {
        this.yqcwrpdyq = yqcwrpdyq;
    }

    public String getYqcwrpdyq() 
    {
        return yqcwrpdyq;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("dxjzlyq", getDxjzlyq())
            .append("gjzlyq", getGjzlyq())
            .append("wcjjkzlyq", getWcjjkzlyq())
            .append("yqcwrpdyq", getYqcwrpdyq())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
