package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-套管性能数据对象 sj_tg_tgxnsj
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
public class SjTgTgxnsj extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 外径 */
    @Excel(name = "外径")
    private Double wj;

    /** 钢级 */
    @Excel(name = "钢级")
    private String gj;

    /** 壁厚 */
    @Excel(name = "壁厚")
    private Double bh;

    /** 扣型 */
    @Excel(name = "扣型")
    private String kx;

    /** 每米重量 */
    @Excel(name = "每米重量")
    private Double mmzl;

    /** 接箍外径 */
    @Excel(name = "接箍外径")
    private Double jgwj;

    /** 抗拉强度 */
    @Excel(name = "抗拉强度")
    private Double klqd;

    /** 抗挤强度 */
    @Excel(name = "抗挤强度")
    private Double kjqd;

    /** 抗内压强度 */
    @Excel(name = "抗内压强度")
    private Double knyqd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setWj(Double wj) 
    {
        this.wj = wj;
    }

    public Double getWj() 
    {
        return wj;
    }

    public void setGj(String gj) 
    {
        this.gj = gj;
    }

    public String getGj() 
    {
        return gj;
    }

    public void setBh(Double bh) 
    {
        this.bh = bh;
    }

    public Double getBh() 
    {
        return bh;
    }

    public void setKx(String kx) 
    {
        this.kx = kx;
    }

    public String getKx() 
    {
        return kx;
    }

    public void setMmzl(Double mmzl) 
    {
        this.mmzl = mmzl;
    }

    public Double getMmzl() 
    {
        return mmzl;
    }

    public void setJgwj(Double jgwj) 
    {
        this.jgwj = jgwj;
    }

    public Double getJgwj() 
    {
        return jgwj;
    }

    public void setKlqd(Double klqd) 
    {
        this.klqd = klqd;
    }

    public Double getKlqd() 
    {
        return klqd;
    }

    public void setKjqd(Double kjqd) 
    {
        this.kjqd = kjqd;
    }

    public Double getKjqd() 
    {
        return kjqd;
    }

    public void setKnyqd(Double knyqd) 
    {
        this.knyqd = knyqd;
    }

    public Double getKnyqd() 
    {
        return knyqd;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("wj", getWj())
            .append("gj", getGj())
            .append("bh", getBh())
            .append("kx", getKx())
            .append("mmzl", getMmzl())
            .append("jgwj", getJgwj())
            .append("klqd", getKlqd())
            .append("kjqd", getKjqd())
            .append("knyqd", getKnyqd())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
