package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-井控专篇对象 sj_jkzp
 * 
 * @author ruoyi
 * @date 2025-07-24
 */
public class SjJkzp extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 钻井口装置 */
    @Excel(name = "钻井口装置")
    private String zjkzz;

    /** 节流管汇压井管汇 */
    @Excel(name = "节流管汇压井管汇")
    private String jlgh;

    /** 井控设备配套以及试压要求 */
    @Excel(name = "井控设备配套以及试压要求")
    private String syyq;

    /** 材料储备 */
    @Excel(name = "材料储备")
    private String clcb;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setZjkzz(String zjkzz) 
    {
        this.zjkzz = zjkzz;
    }

    public String getZjkzz() 
    {
        return zjkzz;
    }

    public void setJlgh(String jlgh) 
    {
        this.jlgh = jlgh;
    }

    public String getJlgh() 
    {
        return jlgh;
    }

    public void setSyyq(String syyq) 
    {
        this.syyq = syyq;
    }

    public String getSyyq() 
    {
        return syyq;
    }

    public void setClcb(String clcb) 
    {
        this.clcb = clcb;
    }

    public String getClcb() 
    {
        return clcb;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("zjkzz", getZjkzz())
            .append("jlgh", getJlgh())
            .append("syyq", getSyyq())
            .append("clcb", getClcb())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
