package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-计划周期对象 sj_jhzq
 * 
 * @author ruoyi
 * @date 2025-07-24
 */
public class SjJhzq extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 施工环节 */
    @Excel(name = "施工环节")
    private String sghj;

    /** 起始井深 */
    @Excel(name = "起始井深")
    private Double qsjs;

    /** 结束井深 */
    @Excel(name = "结束井深")
    private Double jsjs;

    /** 计划周期 */
    @Excel(name = "计划周期")
    private Double jhzq;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setSghj(String sghj) 
    {
        this.sghj = sghj;
    }

    public String getSghj() 
    {
        return sghj;
    }

    public void setQsjs(Double qsjs) 
    {
        this.qsjs = qsjs;
    }

    public Double getQsjs() 
    {
        return qsjs;
    }

    public void setJsjs(Double jsjs) 
    {
        this.jsjs = jsjs;
    }

    public Double getJsjs() 
    {
        return jsjs;
    }

    public void setJhzq(Double jhzq) 
    {
        this.jhzq = jhzq;
    }

    public Double getJhzq() 
    {
        return jhzq;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("sghj", getSghj())
            .append("qsjs", getQsjs())
            .append("jsjs", getJsjs())
            .append("jhzq", getJhzq())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
