package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-H2S对象 sj_h2s
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@Data
public class SjH2s extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /**
     * 邻井井号
     */
    private String ljjh;

    /** 井深 */
    @Excel(name = "井深")
    private Double js;

    /** 工程状态 */
    @Excel(name = "工程状态")
    private String gczt;

    /** 层位 */
    @Excel(name = "层位")
    private String cw;

    /** 显示浓度 */
    @Excel(name = "显示浓度")
    private Double xsbd;

    /** 显示过程与处理 */
    @Excel(name = "显示过程与处理")
    private String xsgc;

    /** 检测时间 */
    @Excel(name = "检测时间")
    private String jcsj;

    /** 检测方法 */
    @Excel(name = "检测方法")
    private String jcfs;

    /** 方位（位于井口） */
    @Excel(name = "方位", readConverterExp = "位=于井口")
    private Double wyjkfw;

    /** 方位（位于井口） */
    @Excel(name = "方位", readConverterExp = "位=于井口")
    private Double wyjkjl;

    /** 方位（位于 A 靶点） */
    @Excel(name = "方位", readConverterExp = "位=于,A=,靶=点")
    private Double wybdfw;

    /** 方位（位于 A 靶点） */
    @Excel(name = "方位", readConverterExp = "位=于,A=,靶=点")
    private Double wybdjl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJs(Double js) 
    {
        this.js = js;
    }

    public Double getJs() 
    {
        return js;
    }

    public void setGczt(String gczt) 
    {
        this.gczt = gczt;
    }

    public String getGczt() 
    {
        return gczt;
    }

    public void setCw(String cw) 
    {
        this.cw = cw;
    }

    public String getCw() 
    {
        return cw;
    }

    public void setXsbd(Double xsbd) 
    {
        this.xsbd = xsbd;
    }

    public Double getXsbd() 
    {
        return xsbd;
    }

    public void setXsgc(String xsgc) 
    {
        this.xsgc = xsgc;
    }

    public String getXsgc() 
    {
        return xsgc;
    }

    public void setJcsj(String jcsj) 
    {
        this.jcsj = jcsj;
    }

    public String getJcsj() 
    {
        return jcsj;
    }

    public void setJcfs(String jcfs) 
    {
        this.jcfs = jcfs;
    }

    public String getJcfs() 
    {
        return jcfs;
    }

    public void setWyjkfw(Double wyjkfw) 
    {
        this.wyjkfw = wyjkfw;
    }

    public Double getWyjkfw() 
    {
        return wyjkfw;
    }

    public void setWyjkjl(Double wyjkjl) 
    {
        this.wyjkjl = wyjkjl;
    }

    public Double getWyjkjl() 
    {
        return wyjkjl;
    }

    public void setWybdfw(Double wybdfw) 
    {
        this.wybdfw = wybdfw;
    }

    public Double getWybdfw() 
    {
        return wybdfw;
    }

    public void setWybdjl(Double wybdjl) 
    {
        this.wybdjl = wybdjl;
    }

    public Double getWybdjl() 
    {
        return wybdjl;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("js", getJs())
            .append("gczt", getGczt())
            .append("cw", getCw())
            .append("xsbd", getXsbd())
            .append("xsgc", getXsgc())
            .append("jcsj", getJcsj())
            .append("jcfs", getJcfs())
            .append("wyjkfw", getWyjkfw())
            .append("wyjkjl", getWyjkjl())
            .append("wybdfw", getWybdfw())
            .append("wybdjl", getWybdjl())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
