package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-附录对象 sj_fl
 * 
 * @author ruoyi
 * @date 2025-07-25
 */
public class SjFl extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 应急联系方式 */
    @Excel(name = "应急联系方式")
    private String yjlxfs;

    /** 喷漏卡塌的预防管控措施 */
    @Excel(name = "喷漏卡塌的预防管控措施")
    private String yfgkcs;

    /** 完井施工措施 */
    @Excel(name = "完井施工措施")
    private String wjsgcs;

    /** 特殊工艺、工具使用指南 */
    @Excel(name = "特殊工艺、工具使用指南")
    private String syzn;

    /** 特殊岩性的知识 */
    @Excel(name = "特殊岩性的知识")
    private String tsyxzs;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setYjlxfs(String yjlxfs) 
    {
        this.yjlxfs = yjlxfs;
    }

    public String getYjlxfs() 
    {
        return yjlxfs;
    }

    public void setYfgkcs(String yfgkcs) 
    {
        this.yfgkcs = yfgkcs;
    }

    public String getYfgkcs() 
    {
        return yfgkcs;
    }

    public void setWjsgcs(String wjsgcs) 
    {
        this.wjsgcs = wjsgcs;
    }

    public String getWjsgcs() 
    {
        return wjsgcs;
    }

    public void setSyzn(String syzn) 
    {
        this.syzn = syzn;
    }

    public String getSyzn() 
    {
        return syzn;
    }

    public void setTsyxzs(String tsyxzs) 
    {
        this.tsyxzs = tsyxzs;
    }

    public String getTsyxzs() 
    {
        return tsyxzs;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("yjlxfs", getYjlxfs())
            .append("yfgkcs", getYfgkcs())
            .append("wjsgcs", getWjsgcs())
            .append("syzn", getSyzn())
            .append("tsyxzs", getTsyxzs())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
